/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundSetTimePacket
implements Packet {
    private final long worldAge;
    private final long time;

    public ClientboundSetTimePacket(NetInput in) throws IOException {
        this.worldAge = in.readLong();
        this.time = in.readLong();
    }

    public void write(NetOutput out) throws IOException {
        out.writeLong(this.worldAge);
        out.writeLong(this.time);
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetTimePacket)) {
            return false;
        }
        ClientboundSetTimePacket other = (ClientboundSetTimePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorldAge() != other.getWorldAge()) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetTimePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $worldAge = this.getWorldAge();
        result = result * 59 + (int)($worldAge >>> 32 ^ $worldAge);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    public String toString() {
        return "ClientboundSetTimePacket(worldAge=" + this.getWorldAge() + ", time=" + this.getTime() + ")";
    }

    public ClientboundSetTimePacket withWorldAge(long worldAge) {
        return this.worldAge == worldAge ? this : new ClientboundSetTimePacket(worldAge, this.time);
    }

    public ClientboundSetTimePacket withTime(long time) {
        return this.time == time ? this : new ClientboundSetTimePacket(this.worldAge, time);
    }

    public ClientboundSetTimePacket(long worldAge, long time) {
        this.worldAge = worldAge;
        this.time = time;
    }
}

