/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.game.NBT;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ClientboundBlockEntityDataPacket
implements Packet {
    @NonNull
    private final Position position;
    private final BlockEntityType type;
    @Nullable
    private final CompoundTag nbt;

    public ClientboundBlockEntityDataPacket(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.type = BlockEntityType.read(in);
        this.nbt = NBT.read(in);
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        BlockEntityType.write(out, this.type);
        NBT.write(out, this.nbt);
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public BlockEntityType getType() {
        return this.type;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockEntityDataPacket)) {
            return false;
        }
        ClientboundBlockEntityDataPacket other = (ClientboundBlockEntityDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockEntityType this$type = this.getType();
        BlockEntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CompoundTag this$nbt = this.getNbt();
        CompoundTag other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockEntityDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockEntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CompoundTag $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockEntityDataPacket(position=" + this.getPosition() + ", type=" + (Object)((Object)this.getType()) + ", nbt=" + this.getNbt() + ")";
    }

    public ClientboundBlockEntityDataPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockEntityDataPacket(position, this.type, this.nbt);
    }

    public ClientboundBlockEntityDataPacket withType(BlockEntityType type) {
        return this.type == type ? this : new ClientboundBlockEntityDataPacket(this.position, type, this.nbt);
    }

    public ClientboundBlockEntityDataPacket withNbt(@Nullable CompoundTag nbt) {
        return this.nbt == nbt ? this : new ClientboundBlockEntityDataPacket(this.position, this.type, nbt);
    }

    public ClientboundBlockEntityDataPacket(@NonNull Position position, BlockEntityType type, @Nullable CompoundTag nbt) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.nbt = nbt;
    }
}

