/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.player.BlockBreakStage;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundBlockDestructionPacket
implements Packet {
    private final int breakerEntityId;
    @NonNull
    private final Position position;
    @NonNull
    private final BlockBreakStage stage;

    public ClientboundBlockDestructionPacket(NetInput in) throws IOException {
        this.breakerEntityId = in.readVarInt();
        this.position = Position.read(in);
        int stage = in.readUnsignedByte();
        this.stage = stage >= 0 && stage < 10 ? BlockBreakStage.STAGES[stage] : BlockBreakStage.RESET;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.breakerEntityId);
        Position.write(out, this.position);
        this.stage.write(out);
    }

    public int getBreakerEntityId() {
        return this.breakerEntityId;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public BlockBreakStage getStage() {
        return this.stage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockDestructionPacket)) {
            return false;
        }
        ClientboundBlockDestructionPacket other = (ClientboundBlockDestructionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBreakerEntityId() != other.getBreakerEntityId()) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockBreakStage this$stage = this.getStage();
        BlockBreakStage other$stage = other.getStage();
        return !(this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockDestructionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBreakerEntityId();
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockBreakStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockDestructionPacket(breakerEntityId=" + this.getBreakerEntityId() + ", position=" + this.getPosition() + ", stage=" + (Object)((Object)this.getStage()) + ")";
    }

    public ClientboundBlockDestructionPacket withBreakerEntityId(int breakerEntityId) {
        return this.breakerEntityId == breakerEntityId ? this : new ClientboundBlockDestructionPacket(breakerEntityId, this.position, this.stage);
    }

    public ClientboundBlockDestructionPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, position, this.stage);
    }

    public ClientboundBlockDestructionPacket withStage(@NonNull BlockBreakStage stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.stage == stage ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, this.position, stage);
    }

    public ClientboundBlockDestructionPacket(int breakerEntityId, @NonNull Position position, @NonNull BlockBreakStage stage) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        this.breakerEntityId = breakerEntityId;
        this.position = position;
        this.stage = stage;
    }
}

