/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import net.kyori.adventure.text.Component;

public class ClientboundPlayerCombatKillPacket
implements Packet {
    private final int playerId;
    private final int killerId;
    private final Component message;

    public ClientboundPlayerCombatKillPacket(NetInput in) throws IOException {
        this.playerId = in.readVarInt();
        this.killerId = in.readInt();
        this.message = DefaultComponentSerializer.get().deserialize((Object)in.readString());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.playerId);
        out.writeInt(this.killerId);
        out.writeString((String)DefaultComponentSerializer.get().serialize(this.message));
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public int getKillerId() {
        return this.killerId;
    }

    public Component getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerCombatKillPacket)) {
            return false;
        }
        ClientboundPlayerCombatKillPacket other = (ClientboundPlayerCombatKillPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPlayerId() != other.getPlayerId()) {
            return false;
        }
        if (this.getKillerId() != other.getKillerId()) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerCombatKillPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPlayerId();
        result = result * 59 + this.getKillerId();
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerCombatKillPacket(playerId=" + this.getPlayerId() + ", killerId=" + this.getKillerId() + ", message=" + this.getMessage() + ")";
    }

    public ClientboundPlayerCombatKillPacket withPlayerId(int playerId) {
        return this.playerId == playerId ? this : new ClientboundPlayerCombatKillPacket(playerId, this.killerId, this.message);
    }

    public ClientboundPlayerCombatKillPacket withKillerId(int killerId) {
        return this.killerId == killerId ? this : new ClientboundPlayerCombatKillPacket(this.playerId, killerId, this.message);
    }

    public ClientboundPlayerCombatKillPacket withMessage(Component message) {
        return this.message == message ? this : new ClientboundPlayerCombatKillPacket(this.playerId, this.killerId, message);
    }

    public ClientboundPlayerCombatKillPacket(int playerId, int killerId, Component message) {
        this.playerId = playerId;
        this.killerId = killerId;
        this.message = message;
    }
}

