/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundMoveVehiclePacket
implements MinecraftPacket {
    private final Vector3d position;
    private final float yRot;
    private final float xRot;
    private final boolean onGround;

    public ServerboundMoveVehiclePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
        this.onGround = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeDouble(this.position.getX());
        out.writeDouble(this.position.getY());
        out.writeDouble(this.position.getZ());
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
        out.writeBoolean(this.onGround);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMoveVehiclePacket)) {
            return false;
        }
        ServerboundMoveVehiclePacket other = (ServerboundMoveVehiclePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        Vector3d this$position = this.getPosition();
        Vector3d other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundMoveVehiclePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        Vector3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundMoveVehiclePacket(position=" + this.getPosition() + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ", onGround=" + this.isOnGround() + ")";
    }

    public @NonNull ServerboundMoveVehiclePacket withPosition(Vector3d position) {
        return this.position == position ? this : new ServerboundMoveVehiclePacket(position, this.yRot, this.xRot, this.onGround);
    }

    public @NonNull ServerboundMoveVehiclePacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ServerboundMoveVehiclePacket(this.position, yRot, this.xRot, this.onGround);
    }

    public @NonNull ServerboundMoveVehiclePacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ServerboundMoveVehiclePacket(this.position, this.yRot, xRot, this.onGround);
    }

    public @NonNull ServerboundMoveVehiclePacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMoveVehiclePacket(this.position, this.yRot, this.xRot, onGround);
    }

    public ServerboundMoveVehiclePacket(Vector3d position, float yRot, float xRot, boolean onGround) {
        this.position = position;
        this.yRot = yRot;
        this.xRot = xRot;
        this.onGround = onGround;
    }
}

