/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundChunkBatchReceivedPacket
implements MinecraftPacket {
    private final float desiredChunksPerTick;

    public ServerboundChunkBatchReceivedPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.desiredChunksPerTick = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.desiredChunksPerTick);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getDesiredChunksPerTick() {
        return this.desiredChunksPerTick;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChunkBatchReceivedPacket)) {
            return false;
        }
        ServerboundChunkBatchReceivedPacket other = (ServerboundChunkBatchReceivedPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getDesiredChunksPerTick(), other.getDesiredChunksPerTick()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChunkBatchReceivedPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDesiredChunksPerTick());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChunkBatchReceivedPacket(desiredChunksPerTick=" + this.getDesiredChunksPerTick() + ")";
    }

    public @NonNull ServerboundChunkBatchReceivedPacket withDesiredChunksPerTick(float desiredChunksPerTick) {
        return this.desiredChunksPerTick == desiredChunksPerTick ? this : new ServerboundChunkBatchReceivedPacket(desiredChunksPerTick);
    }

    public ServerboundChunkBatchReceivedPacket(float desiredChunksPerTick) {
        this.desiredChunksPerTick = desiredChunksPerTick;
    }
}

