/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundSelectBundleItemPacket
implements MinecraftPacket {
    private final int slotId;
    private final int selectedItemIndex;

    public ServerboundSelectBundleItemPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.slotId = helper.readVarInt(in);
        this.selectedItemIndex = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.slotId);
        helper.writeVarInt(out, this.selectedItemIndex);
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSelectBundleItemPacket)) {
            return false;
        }
        ServerboundSelectBundleItemPacket other = (ServerboundSelectBundleItemPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlotId() != other.getSlotId()) {
            return false;
        }
        return this.getSelectedItemIndex() == other.getSelectedItemIndex();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSelectBundleItemPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlotId();
        result = result * 59 + this.getSelectedItemIndex();
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSelectBundleItemPacket(slotId=" + this.getSlotId() + ", selectedItemIndex=" + this.getSelectedItemIndex() + ")";
    }

    public @NonNull ServerboundSelectBundleItemPacket withSlotId(int slotId) {
        return this.slotId == slotId ? this : new ServerboundSelectBundleItemPacket(slotId, this.selectedItemIndex);
    }

    public @NonNull ServerboundSelectBundleItemPacket withSelectedItemIndex(int selectedItemIndex) {
        return this.selectedItemIndex == selectedItemIndex ? this : new ServerboundSelectBundleItemPacket(this.slotId, selectedItemIndex);
    }

    public ServerboundSelectBundleItemPacket(int slotId, int selectedItemIndex) {
        this.slotId = slotId;
        this.selectedItemIndex = selectedItemIndex;
    }
}

