/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetTimePacket
implements MinecraftPacket {
    private final long gameTime;
    private final long dayTime;
    private final boolean tickDayTime;

    public ClientboundSetTimePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.gameTime = in.readLong();
        this.dayTime = in.readLong();
        this.tickDayTime = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeLong(this.gameTime);
        out.writeLong(this.dayTime);
        out.writeBoolean(this.tickDayTime);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public long getDayTime() {
        return this.dayTime;
    }

    public boolean isTickDayTime() {
        return this.tickDayTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetTimePacket)) {
            return false;
        }
        ClientboundSetTimePacket other = (ClientboundSetTimePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGameTime() != other.getGameTime()) {
            return false;
        }
        if (this.getDayTime() != other.getDayTime()) {
            return false;
        }
        return this.isTickDayTime() == other.isTickDayTime();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetTimePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $gameTime = this.getGameTime();
        result = result * 59 + (int)($gameTime >>> 32 ^ $gameTime);
        long $dayTime = this.getDayTime();
        result = result * 59 + (int)($dayTime >>> 32 ^ $dayTime);
        result = result * 59 + (this.isTickDayTime() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetTimePacket(gameTime=" + this.getGameTime() + ", dayTime=" + this.getDayTime() + ", tickDayTime=" + this.isTickDayTime() + ")";
    }

    public @NonNull ClientboundSetTimePacket withGameTime(long gameTime) {
        return this.gameTime == gameTime ? this : new ClientboundSetTimePacket(gameTime, this.dayTime, this.tickDayTime);
    }

    public @NonNull ClientboundSetTimePacket withDayTime(long dayTime) {
        return this.dayTime == dayTime ? this : new ClientboundSetTimePacket(this.gameTime, dayTime, this.tickDayTime);
    }

    public @NonNull ClientboundSetTimePacket withTickDayTime(boolean tickDayTime) {
        return this.tickDayTime == tickDayTime ? this : new ClientboundSetTimePacket(this.gameTime, this.dayTime, tickDayTime);
    }

    public ClientboundSetTimePacket(long gameTime, long dayTime, boolean tickDayTime) {
        this.gameTime = gameTime;
        this.dayTime = dayTime;
        this.tickDayTime = tickDayTime;
    }
}

