/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundOpenSignEditorPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    private final boolean isFrontText;

    public ClientboundOpenSignEditorPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = helper.readPosition(in);
        this.isFrontText = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePosition(out, this.position);
        out.writeBoolean(this.isFrontText);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public boolean isFrontText() {
        return this.isFrontText;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundOpenSignEditorPacket)) {
            return false;
        }
        ClientboundOpenSignEditorPacket other = (ClientboundOpenSignEditorPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFrontText() != other.isFrontText()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundOpenSignEditorPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFrontText() ? 79 : 97);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundOpenSignEditorPacket(position=" + this.getPosition() + ", isFrontText=" + this.isFrontText() + ")";
    }

    public @NonNull ClientboundOpenSignEditorPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundOpenSignEditorPacket(position, this.isFrontText);
    }

    public @NonNull ClientboundOpenSignEditorPacket withFrontText(boolean isFrontText) {
        return this.isFrontText == isFrontText ? this : new ClientboundOpenSignEditorPacket(this.position, isFrontText);
    }

    public ClientboundOpenSignEditorPacket(@lombok.NonNull Vector3i position, boolean isFrontText) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.isFrontText = isFrontText;
    }
}

