/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.RecipeDisplay;

public class ClientboundPlaceGhostRecipePacket
implements MinecraftPacket {
    private final int containerId;
    private final RecipeDisplay recipeDisplay;

    public ClientboundPlaceGhostRecipePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = helper.readVarInt(in);
        this.recipeDisplay = helper.readRecipeDisplay(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.containerId);
        helper.writeRecipeDisplay(out, this.recipeDisplay);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public RecipeDisplay getRecipeDisplay() {
        return this.recipeDisplay;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlaceGhostRecipePacket)) {
            return false;
        }
        ClientboundPlaceGhostRecipePacket other = (ClientboundPlaceGhostRecipePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        RecipeDisplay this$recipeDisplay = this.getRecipeDisplay();
        RecipeDisplay other$recipeDisplay = other.getRecipeDisplay();
        return !(this$recipeDisplay == null ? other$recipeDisplay != null : !this$recipeDisplay.equals(other$recipeDisplay));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlaceGhostRecipePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        RecipeDisplay $recipeDisplay = this.getRecipeDisplay();
        result = result * 59 + ($recipeDisplay == null ? 43 : $recipeDisplay.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlaceGhostRecipePacket(containerId=" + this.getContainerId() + ", recipeDisplay=" + this.getRecipeDisplay() + ")";
    }

    public @NonNull ClientboundPlaceGhostRecipePacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundPlaceGhostRecipePacket(containerId, this.recipeDisplay);
    }

    public @NonNull ClientboundPlaceGhostRecipePacket withRecipeDisplay(RecipeDisplay recipeDisplay) {
        return this.recipeDisplay == recipeDisplay ? this : new ClientboundPlaceGhostRecipePacket(this.containerId, recipeDisplay);
    }

    public ClientboundPlaceGhostRecipePacket(int containerId, RecipeDisplay recipeDisplay) {
        this.containerId = containerId;
        this.recipeDisplay = recipeDisplay;
    }
}

