/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.VillagerTrade;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundMerchantOffersPacket
implements MinecraftPacket {
    private final int containerId;
    @lombok.NonNull
    private final VillagerTrade[] trades;
    private final int villagerLevel;
    private final int experience;
    private final boolean regularVillager;
    private final boolean canRestock;

    public ClientboundMerchantOffersPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = helper.readVarInt(in);
        int size = helper.readVarInt(in);
        this.trades = new VillagerTrade[size];
        for (int i = 0; i < this.trades.length; ++i) {
            ItemStack firstInput = helper.readTradeItemStack(in);
            ItemStack output = helper.readOptionalItemStack(in);
            ItemStack secondInput = helper.readNullable(in, helper::readTradeItemStack);
            boolean tradeDisabled = in.readBoolean();
            int numUses = in.readInt();
            int maxUses = in.readInt();
            int xp = in.readInt();
            int specialPrice = in.readInt();
            float priceMultiplier = in.readFloat();
            int demand = in.readInt();
            this.trades[i] = new VillagerTrade(firstInput, secondInput, output, tradeDisabled, numUses, maxUses, xp, specialPrice, priceMultiplier, demand);
        }
        this.villagerLevel = helper.readVarInt(in);
        this.experience = helper.readVarInt(in);
        this.regularVillager = in.readBoolean();
        this.canRestock = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.containerId);
        helper.writeVarInt(out, this.trades.length);
        for (VillagerTrade trade : this.trades) {
            helper.writeTradeItemStack(out, trade.getFirstInput());
            helper.writeOptionalItemStack(out, trade.getOutput());
            helper.writeNullable(out, trade.getSecondInput(), helper::writeTradeItemStack);
            out.writeBoolean(trade.isTradeDisabled());
            out.writeInt(trade.getNumUses());
            out.writeInt(trade.getMaxUses());
            out.writeInt(trade.getXp());
            out.writeInt(trade.getSpecialPrice());
            out.writeFloat(trade.getPriceMultiplier());
            out.writeInt(trade.getDemand());
        }
        helper.writeVarInt(out, this.villagerLevel);
        helper.writeVarInt(out, this.experience);
        out.writeBoolean(this.regularVillager);
        out.writeBoolean(this.canRestock);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    @lombok.NonNull
    public VillagerTrade[] getTrades() {
        return this.trades;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public int getExperience() {
        return this.experience;
    }

    public boolean isRegularVillager() {
        return this.regularVillager;
    }

    public boolean isCanRestock() {
        return this.canRestock;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMerchantOffersPacket)) {
            return false;
        }
        ClientboundMerchantOffersPacket other = (ClientboundMerchantOffersPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getVillagerLevel() != other.getVillagerLevel()) {
            return false;
        }
        if (this.getExperience() != other.getExperience()) {
            return false;
        }
        if (this.isRegularVillager() != other.isRegularVillager()) {
            return false;
        }
        if (this.isCanRestock() != other.isCanRestock()) {
            return false;
        }
        return Arrays.deepEquals(this.getTrades(), other.getTrades());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMerchantOffersPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getVillagerLevel();
        result = result * 59 + this.getExperience();
        result = result * 59 + (this.isRegularVillager() ? 79 : 97);
        result = result * 59 + (this.isCanRestock() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getTrades());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMerchantOffersPacket(containerId=" + this.getContainerId() + ", trades=" + Arrays.deepToString(this.getTrades()) + ", villagerLevel=" + this.getVillagerLevel() + ", experience=" + this.getExperience() + ", regularVillager=" + this.isRegularVillager() + ", canRestock=" + this.isCanRestock() + ")";
    }

    public @NonNull ClientboundMerchantOffersPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundMerchantOffersPacket(containerId, this.trades, this.villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withTrades(@lombok.NonNull VillagerTrade[] trades) {
        if (trades == null) {
            throw new NullPointerException("trades is marked non-null but is null");
        }
        return this.trades == trades ? this : new ClientboundMerchantOffersPacket(this.containerId, trades, this.villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withVillagerLevel(int villagerLevel) {
        return this.villagerLevel == villagerLevel ? this : new ClientboundMerchantOffersPacket(this.containerId, this.trades, villagerLevel, this.experience, this.regularVillager, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withExperience(int experience) {
        return this.experience == experience ? this : new ClientboundMerchantOffersPacket(this.containerId, this.trades, this.villagerLevel, experience, this.regularVillager, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withRegularVillager(boolean regularVillager) {
        return this.regularVillager == regularVillager ? this : new ClientboundMerchantOffersPacket(this.containerId, this.trades, this.villagerLevel, this.experience, regularVillager, this.canRestock);
    }

    public @NonNull ClientboundMerchantOffersPacket withCanRestock(boolean canRestock) {
        return this.canRestock == canRestock ? this : new ClientboundMerchantOffersPacket(this.containerId, this.trades, this.villagerLevel, this.experience, this.regularVillager, canRestock);
    }

    public ClientboundMerchantOffersPacket(int containerId, @lombok.NonNull VillagerTrade[] trades, int villagerLevel, int experience, boolean regularVillager, boolean canRestock) {
        if (trades == null) {
            throw new NullPointerException("trades is marked non-null but is null");
        }
        this.containerId = containerId;
        this.trades = trades;
        this.villagerLevel = villagerLevel;
        this.experience = experience;
        this.regularVillager = regularVillager;
        this.canRestock = canRestock;
    }
}

