/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetHeldSlotPacket
implements MinecraftPacket {
    private final int slot;

    public ClientboundSetHeldSlotPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.slot = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.slot);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetHeldSlotPacket)) {
            return false;
        }
        ClientboundSetHeldSlotPacket other = (ClientboundSetHeldSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSlot() == other.getSlot();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetHeldSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetHeldSlotPacket(slot=" + this.getSlot() + ")";
    }

    public @NonNull ClientboundSetHeldSlotPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientboundSetHeldSlotPacket(slot);
    }

    public ClientboundSetHeldSlotPacket(int slot) {
        this.slot = slot;
    }
}

