/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetHealthPacket
implements MinecraftPacket {
    private final float health;
    private final int food;
    private final float saturation;

    public ClientboundSetHealthPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.health = in.readFloat();
        this.food = helper.readVarInt(in);
        this.saturation = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.health);
        helper.writeVarInt(out, this.food);
        out.writeFloat(this.saturation);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getHealth() {
        return this.health;
    }

    public int getFood() {
        return this.food;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetHealthPacket)) {
            return false;
        }
        ClientboundSetHealthPacket other = (ClientboundSetHealthPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getHealth(), other.getHealth()) != 0) {
            return false;
        }
        if (this.getFood() != other.getFood()) {
            return false;
        }
        return Float.compare(this.getSaturation(), other.getSaturation()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetHealthPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getHealth());
        result = result * 59 + this.getFood();
        result = result * 59 + Float.floatToIntBits(this.getSaturation());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetHealthPacket(health=" + this.getHealth() + ", food=" + this.getFood() + ", saturation=" + this.getSaturation() + ")";
    }

    public @NonNull ClientboundSetHealthPacket withHealth(float health) {
        return this.health == health ? this : new ClientboundSetHealthPacket(health, this.food, this.saturation);
    }

    public @NonNull ClientboundSetHealthPacket withFood(int food) {
        return this.food == food ? this : new ClientboundSetHealthPacket(this.health, food, this.saturation);
    }

    public @NonNull ClientboundSetHealthPacket withSaturation(float saturation) {
        return this.saturation == saturation ? this : new ClientboundSetHealthPacket(this.health, this.food, saturation);
    }

    public ClientboundSetHealthPacket(float health, int food, float saturation) {
        this.health = health;
        this.food = food;
        this.saturation = saturation;
    }
}

