/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundPlayerRotationPacket
implements MinecraftPacket {
    private final float yRot;
    private final float xRot;

    public ClientboundPlayerRotationPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerRotationPacket)) {
            return false;
        }
        ClientboundPlayerRotationPacket other = (ClientboundPlayerRotationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        return Float.compare(this.getXRot(), other.getXRot()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPlayerRotationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPlayerRotationPacket(yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ")";
    }

    public @NonNull ClientboundPlayerRotationPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundPlayerRotationPacket(yRot, this.xRot);
    }

    public @NonNull ClientboundPlayerRotationPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundPlayerRotationPacket(this.yRot, xRot);
    }

    public ClientboundPlayerRotationPacket(float yRot, float xRot) {
        this.yRot = yRot;
        this.xRot = xRot;
    }
}

