/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundBlockChangedAckPacket
implements MinecraftPacket {
    private final int sequence;

    public ClientboundBlockChangedAckPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.sequence = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.sequence);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockChangedAckPacket)) {
            return false;
        }
        ClientboundBlockChangedAckPacket other = (ClientboundBlockChangedAckPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSequence() == other.getSequence();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundBlockChangedAckPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundBlockChangedAckPacket(sequence=" + this.getSequence() + ")";
    }

    public @NonNull ClientboundBlockChangedAckPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ClientboundBlockChangedAckPacket(sequence);
    }

    public ClientboundBlockChangedAckPacket(int sequence) {
        this.sequence = sequence;
    }
}

