/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundTakeItemEntityPacket
implements MinecraftPacket {
    private final int collectedEntityId;
    private final int collectorEntityId;
    private final int itemCount;

    public ClientboundTakeItemEntityPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.collectedEntityId = helper.readVarInt(in);
        this.collectorEntityId = helper.readVarInt(in);
        this.itemCount = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.collectedEntityId);
        helper.writeVarInt(out, this.collectorEntityId);
        helper.writeVarInt(out, this.itemCount);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getCollectedEntityId() {
        return this.collectedEntityId;
    }

    public int getCollectorEntityId() {
        return this.collectorEntityId;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTakeItemEntityPacket)) {
            return false;
        }
        ClientboundTakeItemEntityPacket other = (ClientboundTakeItemEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCollectedEntityId() != other.getCollectedEntityId()) {
            return false;
        }
        if (this.getCollectorEntityId() != other.getCollectorEntityId()) {
            return false;
        }
        return this.getItemCount() == other.getItemCount();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTakeItemEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCollectedEntityId();
        result = result * 59 + this.getCollectorEntityId();
        result = result * 59 + this.getItemCount();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTakeItemEntityPacket(collectedEntityId=" + this.getCollectedEntityId() + ", collectorEntityId=" + this.getCollectorEntityId() + ", itemCount=" + this.getItemCount() + ")";
    }

    public @NonNull ClientboundTakeItemEntityPacket withCollectedEntityId(int collectedEntityId) {
        return this.collectedEntityId == collectedEntityId ? this : new ClientboundTakeItemEntityPacket(collectedEntityId, this.collectorEntityId, this.itemCount);
    }

    public @NonNull ClientboundTakeItemEntityPacket withCollectorEntityId(int collectorEntityId) {
        return this.collectorEntityId == collectorEntityId ? this : new ClientboundTakeItemEntityPacket(this.collectedEntityId, collectorEntityId, this.itemCount);
    }

    public @NonNull ClientboundTakeItemEntityPacket withItemCount(int itemCount) {
        return this.itemCount == itemCount ? this : new ClientboundTakeItemEntityPacket(this.collectedEntityId, this.collectorEntityId, itemCount);
    }

    public ClientboundTakeItemEntityPacket(int collectedEntityId, int collectorEntityId, int itemCount) {
        this.collectedEntityId = collectedEntityId;
        this.collectorEntityId = collectorEntityId;
        this.itemCount = itemCount;
    }
}

