/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundTickingStepPacket
implements MinecraftPacket {
    private final int tickSteps;

    public ClientboundTickingStepPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.tickSteps = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.tickSteps);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getTickSteps() {
        return this.tickSteps;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTickingStepPacket)) {
            return false;
        }
        ClientboundTickingStepPacket other = (ClientboundTickingStepPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTickSteps() == other.getTickSteps();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTickingStepPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTickSteps();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTickingStepPacket(tickSteps=" + this.getTickSteps() + ")";
    }

    public @NonNull ClientboundTickingStepPacket withTickSteps(int tickSteps) {
        return this.tickSteps == tickSteps ? this : new ClientboundTickingStepPacket(tickSteps);
    }

    public ClientboundTickingStepPacket(int tickSteps) {
        this.tickSteps = tickSteps;
    }
}

