/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundTickingStatePacket
implements MinecraftPacket {
    private final float tickRate;
    private final boolean isFrozen;

    public ClientboundTickingStatePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.tickRate = in.readFloat();
        this.isFrozen = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.tickRate);
        out.writeBoolean(this.isFrozen);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getTickRate() {
        return this.tickRate;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTickingStatePacket)) {
            return false;
        }
        ClientboundTickingStatePacket other = (ClientboundTickingStatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTickRate(), other.getTickRate()) != 0) {
            return false;
        }
        return this.isFrozen() == other.isFrozen();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTickingStatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTickRate());
        result = result * 59 + (this.isFrozen() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTickingStatePacket(tickRate=" + this.getTickRate() + ", isFrozen=" + this.isFrozen() + ")";
    }

    public @NonNull ClientboundTickingStatePacket withTickRate(float tickRate) {
        return this.tickRate == tickRate ? this : new ClientboundTickingStatePacket(tickRate, this.isFrozen);
    }

    public @NonNull ClientboundTickingStatePacket withFrozen(boolean isFrozen) {
        return this.isFrozen == isFrozen ? this : new ClientboundTickingStatePacket(this.tickRate, isFrozen);
    }

    public ClientboundTickingStatePacket(float tickRate, boolean isFrozen) {
        this.tickRate = tickRate;
        this.isFrozen = isFrozen;
    }
}

