/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundRecipeBookRemovePacket
implements MinecraftPacket {
    private final int[] recipes;

    public ClientboundRecipeBookRemovePacket(ByteBuf in, MinecraftCodecHelper helper) {
        int recipeCount = helper.readVarInt(in);
        int[] recipes = new int[recipeCount];
        for (int index = 0; index < recipeCount; ++index) {
            recipes[index] = helper.readVarInt(in);
        }
        this.recipes = recipes;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.recipes.length);
        for (int recipe : this.recipes) {
            helper.writeVarInt(out, recipe);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int[] getRecipes() {
        return this.recipes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRecipeBookRemovePacket)) {
            return false;
        }
        ClientboundRecipeBookRemovePacket other = (ClientboundRecipeBookRemovePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getRecipes(), other.getRecipes());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRecipeBookRemovePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getRecipes());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRecipeBookRemovePacket(recipes=" + Arrays.toString(this.getRecipes()) + ")";
    }

    public @NonNull ClientboundRecipeBookRemovePacket withRecipes(int[] recipes) {
        return this.recipes == recipes ? this : new ClientboundRecipeBookRemovePacket(recipes);
    }

    public ClientboundRecipeBookRemovePacket(int[] recipes) {
        this.recipes = recipes;
    }
}

