/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.RecipeDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.RecipeDisplayEntry;

public class ClientboundRecipeBookAddPacket
implements MinecraftPacket {
    private final List<Entry> entries;
    private final boolean replace;

    public ClientboundRecipeBookAddPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entries = helper.readList(in, buf -> {
            int id = helper.readVarInt((ByteBuf)buf);
            RecipeDisplay display = helper.readRecipeDisplay((ByteBuf)buf);
            int optionalInt = helper.readVarInt((ByteBuf)buf);
            OptionalInt group = optionalInt == 0 ? OptionalInt.empty() : OptionalInt.of(optionalInt - 1);
            int category = helper.readVarInt((ByteBuf)buf);
            List craftingRequirements = helper.readNullable(in, buf1 -> helper.readList((ByteBuf)buf1, helper::readHolderSet));
            byte flags = buf.readByte();
            boolean notification = (flags & 1) != 0;
            boolean highlight = (flags & 2) != 0;
            return new Entry(new RecipeDisplayEntry(id, display, group, category, craftingRequirements), notification, highlight);
        });
        this.replace = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeList(out, this.entries, (buf, entry) -> {
            helper.writeVarInt((ByteBuf)buf, entry.contents().id());
            helper.writeRecipeDisplay((ByteBuf)buf, entry.contents().display());
            helper.writeVarInt((ByteBuf)buf, entry.contents().group().isEmpty() ? 0 : entry.contents().group().getAsInt());
            helper.writeVarInt((ByteBuf)buf, entry.contents().category());
            helper.writeNullable((ByteBuf)buf, entry.contents().craftingRequirements(), (buf1, reqs) -> helper.writeList((ByteBuf)buf1, reqs, helper::writeHolderSet));
            int flags = 0;
            if (entry.notification()) {
                flags |= 1;
            }
            if (entry.highlight()) {
                flags |= 2;
            }
            buf.writeByte(flags);
        });
        out.writeBoolean(this.replace);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRecipeBookAddPacket)) {
            return false;
        }
        ClientboundRecipeBookAddPacket other = (ClientboundRecipeBookAddPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReplace() != other.isReplace()) {
            return false;
        }
        List<Entry> this$entries = this.getEntries();
        List<Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRecipeBookAddPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReplace() ? 79 : 97);
        List<Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRecipeBookAddPacket(entries=" + this.getEntries() + ", replace=" + this.isReplace() + ")";
    }

    public @NonNull ClientboundRecipeBookAddPacket withEntries(List<Entry> entries) {
        return this.entries == entries ? this : new ClientboundRecipeBookAddPacket(entries, this.replace);
    }

    public @NonNull ClientboundRecipeBookAddPacket withReplace(boolean replace) {
        return this.replace == replace ? this : new ClientboundRecipeBookAddPacket(this.entries, replace);
    }

    public ClientboundRecipeBookAddPacket(List<Entry> entries, boolean replace) {
        this.entries = entries;
        this.replace = replace;
    }

    public record Entry(RecipeDisplayEntry contents, boolean notification, boolean highlight) {
    }
}

