/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.RemoteDebugSampleType;

public class ClientboundDebugSamplePacket
implements MinecraftPacket {
    private final long[] sample;
    private final RemoteDebugSampleType debugSampleType;

    public ClientboundDebugSamplePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.sample = helper.readLongArray(in);
        this.debugSampleType = RemoteDebugSampleType.from(helper.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeLongArray(out, this.sample);
        helper.writeVarInt(out, this.debugSampleType.ordinal());
    }

    public long[] getSample() {
        return this.sample;
    }

    public RemoteDebugSampleType getDebugSampleType() {
        return this.debugSampleType;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDebugSamplePacket)) {
            return false;
        }
        ClientboundDebugSamplePacket other = (ClientboundDebugSamplePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSample(), other.getSample())) {
            return false;
        }
        RemoteDebugSampleType this$debugSampleType = this.getDebugSampleType();
        RemoteDebugSampleType other$debugSampleType = other.getDebugSampleType();
        return !(this$debugSampleType == null ? other$debugSampleType != null : !((Object)((Object)this$debugSampleType)).equals((Object)other$debugSampleType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundDebugSamplePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSample());
        RemoteDebugSampleType $debugSampleType = this.getDebugSampleType();
        result = result * 59 + ($debugSampleType == null ? 43 : ((Object)((Object)$debugSampleType)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundDebugSamplePacket(sample=" + Arrays.toString(this.getSample()) + ", debugSampleType=" + this.getDebugSampleType() + ")";
    }

    public @NonNull ClientboundDebugSamplePacket withSample(long[] sample) {
        return this.sample == sample ? this : new ClientboundDebugSamplePacket(sample, this.debugSampleType);
    }

    public @NonNull ClientboundDebugSamplePacket withDebugSampleType(RemoteDebugSampleType debugSampleType) {
        return this.debugSampleType == debugSampleType ? this : new ClientboundDebugSamplePacket(this.sample, debugSampleType);
    }

    public ClientboundDebugSamplePacket(long[] sample, RemoteDebugSampleType debugSampleType) {
        this.sample = sample;
        this.debugSampleType = debugSampleType;
    }
}

