/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.level.notify;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.notify.GameEventValue;

public class RainStrengthValue
implements GameEventValue {
    private final float strength;

    public RainStrengthValue(float strength) {
        if (strength > 1.0f) {
            strength = 1.0f;
        }
        if (strength < 0.0f) {
            strength = 0.0f;
        }
        this.strength = strength;
    }

    public float getStrength() {
        return this.strength;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RainStrengthValue)) {
            return false;
        }
        RainStrengthValue other = (RainStrengthValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getStrength(), other.getStrength()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RainStrengthValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getStrength());
        return result;
    }

    public @NonNull String toString() {
        return "RainStrengthValue(strength=" + this.getStrength() + ")";
    }
}

