/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.Arrays;
import java.util.function.Function;
import lombok.NonNull;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HolderSet {
    private final @Nullable Key location;
    private final int @Nullable [] holders;

    public HolderSet(int @NonNull [] holders) {
        if (holders == null) {
            throw new NullPointerException("holders is marked non-null but is null");
        }
        this.location = null;
        this.holders = holders;
    }

    public HolderSet(@NonNull Key location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
        this.holders = null;
    }

    public int[] resolve(Function<Key, int[]> tagResolver) {
        if (this.holders != null) {
            return this.holders;
        }
        return tagResolver.apply(this.location);
    }

    public String toString() {
        if (this.holders != null) {
            return this.getClass().getSimpleName() + "[holders=" + Arrays.toString(this.holders) + "]";
        }
        return this.getClass().getSimpleName() + "[location=" + this.location + "]";
    }

    public @Nullable Key getLocation() {
        return this.location;
    }

    public int @Nullable [] getHolders() {
        return this.holders;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolderSet)) {
            return false;
        }
        HolderSet other = (HolderSet)o;
        Key this$location = this.getLocation();
        Key other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        return Arrays.equals(this.getHolders(), other.getHolders());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        result = result * 59 + Arrays.hashCode(this.getHolders());
        return result;
    }
}

