/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.network.codec.BasePacketCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BeehiveOccupant;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BlockStateProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BooleanComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ConsumeEffect;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.CustomModelData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DyedItemColor;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.FoodProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Instrument;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.IntComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.JukeboxPlayable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.SuspiciousStewEffect;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Unbreakable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Unit;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.type.BooleanDataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.type.IntDataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.type.ObjectDataComponent;

public class DataComponentType<T> {
    private static final List<DataComponentType<?>> VALUES = new ArrayList();
    public static final DataComponentType<NbtMap> CUSTOM_DATA = new DataComponentType<NbtMap>("custom_data", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final IntComponentType MAX_STACK_SIZE = new IntComponentType("max_stack_size", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final IntComponentType MAX_DAMAGE = new IntComponentType("max_damage", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final IntComponentType DAMAGE = new IntComponentType("damage", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<Unbreakable> UNBREAKABLE = new DataComponentType<Unbreakable>("unbreakable", ItemCodecHelper::readUnbreakable, ItemCodecHelper::writeUnbreakable, ObjectDataComponent::new);
    public static final DataComponentType<Component> CUSTOM_NAME = new DataComponentType<Component>("custom_name", MinecraftCodecHelper::readComponent, MinecraftCodecHelper::writeComponent, ObjectDataComponent::new);
    public static final DataComponentType<Component> ITEM_NAME = new DataComponentType<Component>("item_name", MinecraftCodecHelper::readComponent, MinecraftCodecHelper::writeComponent, ObjectDataComponent::new);
    public static final DataComponentType<Key> ITEM_MODEL = new DataComponentType<Key>("item_model", MinecraftCodecHelper::readResourceLocation, MinecraftCodecHelper::writeResourceLocation, ObjectDataComponent::new);
    public static final DataComponentType<List<Component>> LORE = new DataComponentType<List>("lore", DataComponentType.listReader(MinecraftCodecHelper::readComponent), DataComponentType.listWriter(MinecraftCodecHelper::writeComponent), ObjectDataComponent::new);
    public static final IntComponentType RARITY = new IntComponentType("rarity", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<ItemEnchantments> ENCHANTMENTS = new DataComponentType<ItemEnchantments>("enchantments", ItemCodecHelper::readItemEnchantments, ItemCodecHelper::writeItemEnchantments, ObjectDataComponent::new);
    public static final DataComponentType<AdventureModePredicate> CAN_PLACE_ON = new DataComponentType<AdventureModePredicate>("can_place_on", ItemCodecHelper::readAdventureModePredicate, ItemCodecHelper::writeAdventureModePredicate, ObjectDataComponent::new);
    public static final DataComponentType<AdventureModePredicate> CAN_BREAK = new DataComponentType<AdventureModePredicate>("can_break", ItemCodecHelper::readAdventureModePredicate, ItemCodecHelper::writeAdventureModePredicate, ObjectDataComponent::new);
    public static final DataComponentType<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = new DataComponentType<ItemAttributeModifiers>("attribute_modifiers", ItemCodecHelper::readItemAttributeModifiers, ItemCodecHelper::writeItemAttributeModifiers, ObjectDataComponent::new);
    public static final DataComponentType<CustomModelData> CUSTOM_MODEL_DATA = new DataComponentType<CustomModelData>("custom_model_data", ItemCodecHelper::readCustomModelData, ItemCodecHelper::writeCustomModelData, ObjectDataComponent::new);
    public static final DataComponentType<Unit> HIDE_ADDITIONAL_TOOLTIP = new DataComponentType<Unit>("hide_additional_tooltip", DataComponentType.unitReader(), DataComponentType.unitWriter(), ObjectDataComponent::new);
    public static final DataComponentType<Unit> HIDE_TOOLTIP = new DataComponentType<Unit>("hide_tooltip", DataComponentType.unitReader(), DataComponentType.unitWriter(), ObjectDataComponent::new);
    public static final IntComponentType REPAIR_COST = new IntComponentType("repair_cost", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<Unit> CREATIVE_SLOT_LOCK = new DataComponentType<Unit>("creative_slot_lock", DataComponentType.unitReader(), DataComponentType.unitWriter(), ObjectDataComponent::new);
    public static final BooleanComponentType ENCHANTMENT_GLINT_OVERRIDE = new BooleanComponentType("enchantment_glint_override", ByteBuf::readBoolean, ByteBuf::writeBoolean, BooleanDataComponent::new);
    public static final DataComponentType<NbtMap> INTANGIBLE_PROJECTILE = new DataComponentType<NbtMap>("intangible_projectile", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<FoodProperties> FOOD = new DataComponentType<FoodProperties>("food", ItemCodecHelper::readFoodProperties, ItemCodecHelper::writeFoodProperties, ObjectDataComponent::new);
    public static final DataComponentType<Consumable> CONSUMABLE = new DataComponentType<Consumable>("consumable", ItemCodecHelper::readConsumable, ItemCodecHelper::writeConsumable, ObjectDataComponent::new);
    public static final DataComponentType<ItemStack> USE_REMAINDER = new DataComponentType<ItemStack>("use_remainder", MinecraftCodecHelper::readItemStack, MinecraftCodecHelper::writeItemStack, ObjectDataComponent::new);
    public static final DataComponentType<UseCooldown> USE_COOLDOWN = new DataComponentType<UseCooldown>("use_cooldown", ItemCodecHelper::readUseCooldown, ItemCodecHelper::writeUseCooldown, ObjectDataComponent::new);
    public static final DataComponentType<Key> DAMAGE_RESISTANT = new DataComponentType<Key>("damage_resistant", MinecraftCodecHelper::readResourceLocation, MinecraftCodecHelper::writeResourceLocation, ObjectDataComponent::new);
    public static final DataComponentType<ToolData> TOOL = new DataComponentType<ToolData>("tool", ItemCodecHelper::readToolData, ItemCodecHelper::writeToolData, ObjectDataComponent::new);
    public static final IntComponentType ENCHANTABLE = new IntComponentType("enchantable", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<Equippable> EQUIPPABLE = new DataComponentType<Equippable>("equippable", ItemCodecHelper::readEquippable, ItemCodecHelper::writeEquippable, ObjectDataComponent::new);
    public static final DataComponentType<HolderSet> REPAIRABLE = new DataComponentType<HolderSet>("repairable", MinecraftCodecHelper::readHolderSet, MinecraftCodecHelper::writeHolderSet, ObjectDataComponent::new);
    public static final DataComponentType<Unit> GLIDER = new DataComponentType<Unit>("glider", DataComponentType.unitReader(), DataComponentType.unitWriter(), ObjectDataComponent::new);
    public static final DataComponentType<Key> TOOLTIP_STYLE = new DataComponentType<Key>("tooltip_style", MinecraftCodecHelper::readResourceLocation, MinecraftCodecHelper::writeResourceLocation, ObjectDataComponent::new);
    public static final DataComponentType<List<ConsumeEffect>> DEATH_PROTECTION = new DataComponentType<List>("death_protection", DataComponentType.listReader(ItemCodecHelper::readConsumeEffect), DataComponentType.listWriter(ItemCodecHelper::writeConsumeEffect), ObjectDataComponent::new);
    public static final DataComponentType<ItemEnchantments> STORED_ENCHANTMENTS = new DataComponentType<ItemEnchantments>("stored_enchantments", ItemCodecHelper::readItemEnchantments, ItemCodecHelper::writeItemEnchantments, ObjectDataComponent::new);
    public static final DataComponentType<DyedItemColor> DYED_COLOR = new DataComponentType<DyedItemColor>("dyed_color", ItemCodecHelper::readDyedItemColor, ItemCodecHelper::writeDyedItemColor, ObjectDataComponent::new);
    public static final IntComponentType MAP_COLOR = new IntComponentType("map_color", (helper, input) -> input.readInt(), (helper, output, value) -> output.writeInt(value), IntDataComponent::new);
    public static final IntComponentType MAP_ID = new IntComponentType("map_id", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<NbtMap> MAP_DECORATIONS = new DataComponentType<NbtMap>("map_decorations", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final IntComponentType MAP_POST_PROCESSING = new IntComponentType("map_post_processing", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<List<ItemStack>> CHARGED_PROJECTILES = new DataComponentType<List>("charged_projectiles", DataComponentType.listReader(MinecraftCodecHelper::readItemStack), DataComponentType.listWriter(MinecraftCodecHelper::writeItemStack), ObjectDataComponent::new);
    public static final DataComponentType<List<ItemStack>> BUNDLE_CONTENTS = new DataComponentType<List>("bundle_contents", DataComponentType.listReader(MinecraftCodecHelper::readItemStack), DataComponentType.listWriter(MinecraftCodecHelper::writeItemStack), ObjectDataComponent::new);
    public static final DataComponentType<PotionContents> POTION_CONTENTS = new DataComponentType<PotionContents>("potion_contents", ItemCodecHelper::readPotionContents, ItemCodecHelper::writePotionContents, ObjectDataComponent::new);
    public static final DataComponentType<List<SuspiciousStewEffect>> SUSPICIOUS_STEW_EFFECTS = new DataComponentType<List>("suspicious_stew_effects", DataComponentType.listReader(ItemCodecHelper::readStewEffect), DataComponentType.listWriter(ItemCodecHelper::writeStewEffect), ObjectDataComponent::new);
    public static final DataComponentType<WritableBookContent> WRITABLE_BOOK_CONTENT = new DataComponentType<WritableBookContent>("writable_book_content", ItemCodecHelper::readWritableBookContent, ItemCodecHelper::writeWritableBookContent, ObjectDataComponent::new);
    public static final DataComponentType<WrittenBookContent> WRITTEN_BOOK_CONTENT = new DataComponentType<WrittenBookContent>("written_book_content", ItemCodecHelper::readWrittenBookContent, ItemCodecHelper::writeWrittenBookContent, ObjectDataComponent::new);
    public static final DataComponentType<ArmorTrim> TRIM = new DataComponentType<ArmorTrim>("trim", ItemCodecHelper::readArmorTrim, ItemCodecHelper::writeArmorTrim, ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> DEBUG_STICK_STATE = new DataComponentType<NbtMap>("debug_stick_state", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> ENTITY_DATA = new DataComponentType<NbtMap>("entity_data", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> BUCKET_ENTITY_DATA = new DataComponentType<NbtMap>("bucket_entity_data", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> BLOCK_ENTITY_DATA = new DataComponentType<NbtMap>("block_entity_data", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<Holder<Instrument>> INSTRUMENT = new DataComponentType<Holder>("instrument", ItemCodecHelper::readInstrument, ItemCodecHelper::writeInstrument, ObjectDataComponent::new);
    public static final IntComponentType OMINOUS_BOTTLE_AMPLIFIER = new IntComponentType("ominous_bottle_amplifier", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<JukeboxPlayable> JUKEBOX_PLAYABLE = new DataComponentType<JukeboxPlayable>("jukebox_playable", ItemCodecHelper::readJukeboxPlayable, ItemCodecHelper::writeJukeboxPlayable, ObjectDataComponent::new);
    public static final DataComponentType<NbtList<?>> RECIPES = new DataComponentType<NbtList>("recipes", ItemCodecHelper::readRecipes, ItemCodecHelper::writeRecipes, ObjectDataComponent::new);
    public static final DataComponentType<LodestoneTracker> LODESTONE_TRACKER = new DataComponentType<LodestoneTracker>("lodestone_tracker", ItemCodecHelper::readLodestoneTarget, ItemCodecHelper::writeLodestoneTarget, ObjectDataComponent::new);
    public static final DataComponentType<Fireworks.FireworkExplosion> FIREWORK_EXPLOSION = new DataComponentType<Fireworks.FireworkExplosion>("firework_explosion", ItemCodecHelper::readFireworkExplosion, ItemCodecHelper::writeFireworkExplosion, ObjectDataComponent::new);
    public static final DataComponentType<Fireworks> FIREWORKS = new DataComponentType<Fireworks>("fireworks", ItemCodecHelper::readFireworks, ItemCodecHelper::writeFireworks, ObjectDataComponent::new);
    public static final DataComponentType<GameProfile> PROFILE = new DataComponentType<GameProfile>("profile", ItemCodecHelper::readResolvableProfile, ItemCodecHelper::writeResolvableProfile, ObjectDataComponent::new);
    public static final DataComponentType<Key> NOTE_BLOCK_SOUND = new DataComponentType<Key>("note_block_sound", MinecraftCodecHelper::readResourceLocation, MinecraftCodecHelper::writeResourceLocation, ObjectDataComponent::new);
    public static final DataComponentType<List<BannerPatternLayer>> BANNER_PATTERNS = new DataComponentType<List>("banner_patterns", DataComponentType.listReader(ItemCodecHelper::readBannerPatternLayer), DataComponentType.listWriter(ItemCodecHelper::writeBannerPatternLayer), ObjectDataComponent::new);
    public static final IntComponentType BASE_COLOR = new IntComponentType("base_color", BasePacketCodecHelper::readVarInt, BasePacketCodecHelper::writeVarInt, IntDataComponent::new);
    public static final DataComponentType<List<Integer>> POT_DECORATIONS = new DataComponentType<List>("pot_decorations", DataComponentType.listReader(BasePacketCodecHelper::readVarInt), DataComponentType.listWriter(BasePacketCodecHelper::writeVarInt), ObjectDataComponent::new);
    public static final DataComponentType<List<ItemStack>> CONTAINER = new DataComponentType<List>("container", DataComponentType.listReader(MinecraftCodecHelper::readOptionalItemStack), DataComponentType.listWriter(MinecraftCodecHelper::writeOptionalItemStack), ObjectDataComponent::new);
    public static final DataComponentType<BlockStateProperties> BLOCK_STATE = new DataComponentType<BlockStateProperties>("block_state", ItemCodecHelper::readBlockStateProperties, ItemCodecHelper::writeBlockStateProperties, ObjectDataComponent::new);
    public static final DataComponentType<List<BeehiveOccupant>> BEES = new DataComponentType<List>("bees", DataComponentType.listReader(ItemCodecHelper::readBeehiveOccupant), DataComponentType.listWriter(ItemCodecHelper::writeBeehiveOccupant), ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> LOCK = new DataComponentType<NbtMap>("lock", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    public static final DataComponentType<NbtMap> CONTAINER_LOOT = new DataComponentType<NbtMap>("container_loot", MinecraftCodecHelper::readCompoundTag, MinecraftCodecHelper::writeAnyTag, ObjectDataComponent::new);
    protected final int id = VALUES.size();
    protected final Key key;
    protected final Reader<T> reader;
    protected final Writer<T> writer;
    protected final DataComponentFactory<T> dataComponentFactory;

    protected DataComponentType(String key, Reader<T> reader, Writer<T> writer, DataComponentFactory<T> dataComponentFactory) {
        this.key = Key.key((String)key);
        this.reader = reader;
        this.writer = writer;
        this.dataComponentFactory = dataComponentFactory;
        VALUES.add(this);
    }

    public DataComponent<T, ? extends DataComponentType<T>> readDataComponent(ItemCodecHelper helper, ByteBuf input) {
        return this.dataComponentFactory.create(this, this.reader.read(helper, input));
    }

    public DataComponent<T, ? extends DataComponentType<T>> readNullDataComponent() {
        return this.dataComponentFactory.create(this, null);
    }

    public void writeDataComponent(ItemCodecHelper helper, ByteBuf output, T value) {
        this.writer.write(helper, output, value);
    }

    private static <T> Reader<List<T>> listReader(Reader<T> reader) {
        return (helper, input) -> {
            ArrayList ret = new ArrayList();
            int size = helper.readVarInt(input);
            for (int i = 0; i < size; ++i) {
                ret.add(reader.read(helper, input));
            }
            return ret;
        };
    }

    private static <T> Writer<List<T>> listWriter(Writer<T> writer) {
        return (helper, output, value) -> {
            helper.writeVarInt(output, value.size());
            for (Object object : value) {
                writer.write(helper, output, object);
            }
        };
    }

    private static Reader<Unit> unitReader() {
        return (helper, input) -> Unit.INSTANCE;
    }

    private static Writer<Unit> unitWriter() {
        return (helper, output, value) -> {};
    }

    public static DataComponentType<?> read(ByteBuf in, MinecraftCodecHelper helper) {
        int id = helper.readVarInt(in);
        if (id >= VALUES.size()) {
            throw new IllegalArgumentException("Received id " + id + " for DataComponentType when the maximum was " + VALUES.size() + "!");
        }
        return VALUES.get(id);
    }

    public static DataComponentType<?> from(int id) {
        return VALUES.get(id);
    }

    public static int size() {
        return VALUES.size();
    }

    public String toString() {
        return "DataComponentType(id=" + this.id + " , key=" + this.key.asString() + ")";
    }

    public int getId() {
        return this.id;
    }

    public Key getKey() {
        return this.key;
    }

    public Reader<T> getReader() {
        return this.reader;
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public DataComponentFactory<T> getDataComponentFactory() {
        return this.dataComponentFactory;
    }

    @FunctionalInterface
    public static interface Reader<V> {
        public V read(ItemCodecHelper var1, ByteBuf var2);
    }

    @FunctionalInterface
    public static interface Writer<V> {
        public void write(ItemCodecHelper var1, ByteBuf var2, V var3);
    }

    @FunctionalInterface
    public static interface DataComponentFactory<V> {
        public DataComponent<V, ? extends DataComponentType<V>> create(DataComponentType<V> var1, V var2);
    }

    @FunctionalInterface
    public static interface BasicWriter<V>
    extends Writer<V> {
        public void write(ByteBuf var1, V var2);

        @Override
        default public void write(ItemCodecHelper helper, ByteBuf output, V value) {
            this.write(output, value);
        }
    }

    @FunctionalInterface
    public static interface BasicReader<V>
    extends Reader<V> {
        public V read(ByteBuf var1);

        @Override
        default public V read(ItemCodecHelper helper, ByteBuf input) {
            return this.read(input);
        }
    }
}

