/*
 * Decompiled with CFR 0.152.
 */
package com.foysaltech.scratchcardlayout.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.cardview.widget.CardView;
import com.foysaltech.scratchcardlayout.listener.ScratchListener;
import com.foysaltech.scratchcardlayout.ui.ScratchCard;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u000fH\u0002J\b\u0010\"\u001a\u00020\u000fH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/foysaltech/scratchcardlayout/ui/ScratchCardLayout;", "Landroidx/cardview/widget/CardView;", "Lcom/foysaltech/scratchcardlayout/ui/ScratchCard$ScratchCardInterface;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "scratchCard", "Lcom/foysaltech/scratchcardlayout/ui/ScratchCard;", "init", "", "onFullReveal", "resetScratch", "revealScratch", "setRevealFullAtPercent", "revealFullAtPercent", "setScratchDrawable", "mScratchDrawable", "Landroid/graphics/drawable/Drawable;", "setScratchEnabled", "enableScratching", "", "setScratchListener", "mListener", "Lcom/foysaltech/scratchcardlayout/listener/ScratchListener;", "setScratchWidthDip", "mScratchWidthDip", "", "setupScratchView", "stopScratching", "scratchcardlayout_release"})
public final class ScratchCardLayout
extends CardView
implements ScratchCard.ScratchCardInterface {
    private ScratchCard scratchCard;

    public ScratchCardLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init(context, null, 0);
    }

    public ScratchCardLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public ScratchCardLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private final void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.scratchCard = new ScratchCard(context, attrs, defStyleAttr);
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setRevealListener(this);
        this.setupScratchView();
        this.resetScratch();
    }

    public final void setScratchWidthDip(float mScratchWidthDip) {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setScratchWidthDip(mScratchWidthDip);
    }

    public final void setScratchDrawable(@Nullable Drawable mScratchDrawable) {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setScratchDrawable(mScratchDrawable);
    }

    public final void setScratchListener(@NotNull ScratchListener mListener) {
        Intrinsics.checkNotNullParameter((Object)mListener, (String)"mListener");
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setListener(mListener);
    }

    private final void setupScratchView() {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.post(() -> ScratchCardLayout.setupScratchView$lambda$0(this));
    }

    private final void stopScratching() {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setVisibility(8);
    }

    public final void setRevealFullAtPercent(int revealFullAtPercent) {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setRevealFullAtPercent(revealFullAtPercent);
    }

    @Override
    public void onFullReveal() {
        this.stopScratching();
    }

    public final void setScratchEnabled(boolean enableScratching) {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.setScratchEnabled(enableScratching);
    }

    public final void resetScratch() {
        this.setScratchEnabled(true);
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.resetScratch();
    }

    public final void revealScratch() {
        ScratchCard scratchCard = this.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        scratchCard.revealScratch();
    }

    private static final void setupScratchView$lambda$0(ScratchCardLayout this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ScratchCard scratchCard = this$0.scratchCard;
        if (scratchCard == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scratchCard");
            scratchCard = null;
        }
        this$0.addView(scratchCard);
    }
}

