/*
 * Decompiled with CFR 0.152.
 */
package com.github.pdfviewer.scroll;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.github.pdfviewer.PDFView;
import com.github.pdfviewer.R;
import com.github.pdfviewer.scroll.ScrollHandle;
import com.github.pdfviewer.util.Util;

public class DefaultScrollHandle
extends RelativeLayout
implements ScrollHandle {
    private static final int HANDLE_LONG = 65;
    private static final int HANDLE_SHORT = 40;
    private static final int DEFAULT_TEXT_SIZE = 16;
    private float relativeHandlerMiddle = 0.0f;
    protected TextView textView;
    protected Context context;
    private boolean inverted;
    private PDFView pdfView;
    private float currentPos;
    private Handler handler = new Handler();
    private Runnable hidePageScrollerRunnable = new Runnable(){

        @Override
        public void run() {
            DefaultScrollHandle.this.hide();
        }
    };

    public DefaultScrollHandle(Context context) {
        this(context, false);
    }

    public DefaultScrollHandle(Context context, boolean inverted) {
        super(context);
        this.context = context;
        this.inverted = inverted;
        this.textView = new TextView(context);
        this.setVisibility(4);
        this.setTextColor(-16777216);
        this.setTextSize(16);
    }

    @Override
    public void setupLayout(PDFView pdfView) {
        Drawable background;
        int align;
        int height;
        int width;
        if (pdfView.isSwipeVertical()) {
            width = 65;
            height = 40;
            if (this.inverted) {
                align = 9;
                background = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.default_scroll_handle_left);
            } else {
                align = 11;
                background = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.default_scroll_handle_right);
            }
        } else {
            width = 40;
            height = 65;
            if (this.inverted) {
                align = 10;
                background = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.default_scroll_handle_top);
            } else {
                align = 12;
                background = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.default_scroll_handle_bottom);
            }
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable(background);
        } else {
            this.setBackground(background);
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Util.getDP(this.context, width), Util.getDP(this.context, height));
        lp.setMargins(0, 0, 0, 0);
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        lp.addRule(align);
        pdfView.addView((View)this, (ViewGroup.LayoutParams)lp);
        this.pdfView = pdfView;
    }

    @Override
    public void destroyLayout() {
        this.pdfView.removeView((View)this);
    }

    @Override
    public void setScroll(float position) {
        if (!this.shown()) {
            this.show();
        } else {
            this.handler.removeCallbacks(this.hidePageScrollerRunnable);
        }
        if (this.pdfView != null) {
            this.setPosition((float)(this.pdfView.isSwipeVertical() ? this.pdfView.getHeight() : this.pdfView.getWidth()) * position);
        }
    }

    private void setPosition(float pos) {
        if (Float.isInfinite(pos) || Float.isNaN(pos)) {
            return;
        }
        float pdfViewSize = this.pdfView.isSwipeVertical() ? (float)this.pdfView.getHeight() : (float)this.pdfView.getWidth();
        if ((pos -= this.relativeHandlerMiddle) < 0.0f) {
            pos = 0.0f;
        } else if (pos > pdfViewSize - (float)Util.getDP(this.context, 40)) {
            pos = pdfViewSize - (float)Util.getDP(this.context, 40);
        }
        if (this.pdfView.isSwipeVertical()) {
            this.setY(pos);
        } else {
            this.setX(pos);
        }
        this.calculateMiddle();
        this.invalidate();
    }

    private void calculateMiddle() {
        float pdfViewSize;
        float viewSize;
        float pos;
        if (this.pdfView.isSwipeVertical()) {
            pos = this.getY();
            viewSize = this.getHeight();
            pdfViewSize = this.pdfView.getHeight();
        } else {
            pos = this.getX();
            viewSize = this.getWidth();
            pdfViewSize = this.pdfView.getWidth();
        }
        this.relativeHandlerMiddle = (pos + this.relativeHandlerMiddle) / pdfViewSize * viewSize;
    }

    @Override
    public void hideDelayed() {
        this.handler.postDelayed(this.hidePageScrollerRunnable, 1000L);
    }

    @Override
    public void setPageNum(int pageNum) {
        String text = String.valueOf(pageNum);
        if (!this.textView.getText().equals(text)) {
            this.textView.setText((CharSequence)text);
        }
    }

    @Override
    public boolean shown() {
        return this.getVisibility() == 0;
    }

    @Override
    public void show() {
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(4);
    }

    public void setTextColor(int color) {
        this.textView.setTextColor(color);
    }

    public void setTextSize(int size) {
        this.textView.setTextSize(1, (float)size);
    }

    private boolean isPDFViewReady() {
        return this.pdfView != null && this.pdfView.getPageCount() > 0 && !this.pdfView.documentFitsView();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isPDFViewReady()) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: 
            case 5: {
                this.pdfView.stopFling();
                this.handler.removeCallbacks(this.hidePageScrollerRunnable);
                this.currentPos = this.pdfView.isSwipeVertical() ? event.getRawY() - this.getY() : event.getRawX() - this.getX();
            }
            case 2: {
                if (this.pdfView.isSwipeVertical()) {
                    this.setPosition(event.getRawY() - this.currentPos + this.relativeHandlerMiddle);
                    this.pdfView.setPositionOffset(this.relativeHandlerMiddle / (float)this.getHeight(), false);
                } else {
                    this.setPosition(event.getRawX() - this.currentPos + this.relativeHandlerMiddle);
                    this.pdfView.setPositionOffset(this.relativeHandlerMiddle / (float)this.getWidth(), false);
                }
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                this.hideDelayed();
                this.pdfView.performPageSnap();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }
}

