/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.folioreader.model.HighLight;
import com.folioreader.model.HighlightImpl;
import com.folioreader.model.sqlite.HighLightTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class HighlightUtil {
    private static final String TAG = "HighlightUtil";

    public static String createHighlightRangy(Context context, String content, String bookId, String pageId, int pageNo, String oldRangy) {
        try {
            JSONObject jObject = new JSONObject(content);
            String rangy = jObject.getString("rangy");
            String textContent = jObject.getString("content");
            String color2 = jObject.getString("color");
            String rangyHighlightElement = HighlightUtil.getRangyString(rangy, oldRangy);
            HighlightImpl highlightImpl = new HighlightImpl();
            highlightImpl.setContent(textContent);
            highlightImpl.setType(color2);
            highlightImpl.setPageNumber(pageNo);
            highlightImpl.setBookId(bookId);
            highlightImpl.setPageId(pageId);
            highlightImpl.setRangy(rangyHighlightElement);
            highlightImpl.setDate(Calendar.getInstance().getTime());
            long id2 = HighLightTable.insertHighlight(highlightImpl);
            if (id2 != -1L) {
                highlightImpl.setId((int)id2);
                HighlightUtil.sendHighlightBroadcastEvent(context, highlightImpl, HighLight.HighLightAction.NEW);
            }
            return rangy;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"createHighlightRangy failed", (Throwable)e);
            return "";
        }
    }

    private static String getRangyString(String rangy, String oldRangy) {
        List<String> rangyList = HighlightUtil.getRangyArray(rangy);
        for (String firs : HighlightUtil.getRangyArray(oldRangy)) {
            if (!rangyList.contains(firs)) continue;
            rangyList.remove(firs);
        }
        if (rangyList.size() >= 1) {
            return rangyList.get(0);
        }
        return "";
    }

    private static List<String> getRangyArray(String rangy) {
        ArrayList<String> rangyElementList = new ArrayList<String>();
        rangyElementList.addAll(Arrays.asList(rangy.split("\\|")));
        if (rangyElementList.contains("type:textContent")) {
            rangyElementList.remove("type:textContent");
        } else if (rangyElementList.contains("")) {
            return new ArrayList<String>();
        }
        return rangyElementList;
    }

    public static String generateRangyString(String pageId) {
        List<String> rangyList = HighLightTable.getHighlightsForPageId(pageId);
        StringBuilder builder = new StringBuilder();
        if (!rangyList.isEmpty()) {
            builder.append("type:textContent");
            for (String rangy : rangyList) {
                builder.append('|');
                builder.append(rangy);
            }
        }
        return builder.toString();
    }

    public static void sendHighlightBroadcastEvent(Context context, HighlightImpl highlightImpl, HighLight.HighLightAction action) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(HighlightUtil.getHighlightBroadcastIntent(highlightImpl, action));
    }

    public static Intent getHighlightBroadcastIntent(HighlightImpl highlightImpl, HighLight.HighLightAction modify) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(HighlightImpl.INTENT, (Parcelable)highlightImpl);
        bundle.putSerializable(HighLight.HighLightAction.class.getName(), (Serializable)((Object)modify));
        return new Intent("highlight_broadcast_event").putExtras(bundle);
    }
}

