/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.base;

import android.os.AsyncTask;
import android.util.Log;
import com.folioreader.model.dictionary.Wikipedia;
import com.folioreader.ui.base.WikipediaCallBack;
import com.folioreader.util.AppUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.json.JSONArray;
import org.json.JSONException;

public class WikipediaTask
extends AsyncTask<String, Void, Wikipedia> {
    private static final String TAG = "WikipediaTask";
    private WikipediaCallBack callBack;

    public WikipediaTask(WikipediaCallBack callBack) {
        this.callBack = callBack;
    }

    protected Wikipedia doInBackground(String ... strings) {
        String strUrl = strings[0];
        try {
            String line;
            Log.v((String)TAG, (String)("-> doInBackground -> url -> " + strUrl));
            URL url = new URL(strUrl);
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, AppUtil.charsetNameForURLConnection(urlConnection)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            try {
                JSONArray array = new JSONArray(stringBuilder.toString());
                if (array.length() == 4) {
                    try {
                        Wikipedia wikipedia = new Wikipedia();
                        wikipedia.setWord(array.get(0).toString());
                        JSONArray defs = (JSONArray)array.get(2);
                        wikipedia.setDefinition(defs.get(0).toString());
                        JSONArray links = (JSONArray)array.get(3);
                        wikipedia.setLink(links.get(0).toString());
                        return wikipedia;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"WikipediaTask failed", (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"WikipediaTask failed", (Throwable)e);
                return null;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"WikipediaTask failed", (Throwable)e);
            return null;
        }
    }

    protected void onPostExecute(Wikipedia wikipedia) {
        super.onPostExecute((Object)wikipedia);
        if (wikipedia != null) {
            this.callBack.onWikipediaDataReceived(wikipedia);
        } else {
            this.callBack.onError();
        }
        this.cancel(true);
    }
}

