/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.os.Handler;
import com.eulerian.android.sdk.ConnectivityHelper;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAnalytics;
import com.eulerian.android.sdk.FileHelper;
import com.eulerian.android.sdk.HttpHelper;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StoredPropertiesTracker
implements Runnable {
    private final Handler handler;

    public StoredPropertiesTracker(Handler ui) {
        this.handler = ui;
    }

    @Override
    public void run() {
        EALog.d("Tracking stored properties");
        this.handler.removeMessages(1);
        if (!ConnectivityHelper.isConnected(EAnalytics.getContext())) {
            EALog.d("-> no network access. Properties is being stored and will be sent later.", true);
            this.handler.sendEmptyMessageDelayed(1, 60000L);
            return;
        }
        List<String> storedProperties = FileHelper.getLines();
        if (storedProperties.isEmpty()) {
            EALog.d("-> no properties stored.");
            return;
        }
        EALog.d("-> " + storedProperties.size() + " stored properties found. Added for synchronization.");
        int result = StoredPropertiesTracker.postStoredProperties(storedProperties);
        if (result == -1) {
            this.handler.sendEmptyMessageDelayed(1, 5000L);
        } else {
            EALog.d("-> all properties tracked successfully. Stored properties is now empty.");
        }
    }

    public static int postStoredProperties(List<String> storedProperties) {
        int counter = 0;
        JSONArray jsonArray = new JSONArray();
        do {
            String line = storedProperties.get(counter);
            try {
                JSONObject lineJson = new JSONObject(line);
                jsonArray.put((Object)lineJson);
                if (counter != storedProperties.size() - 1 && (long)(jsonArray.toString().getBytes().length + storedProperties.get(counter + 1).getBytes().length) <= 100000L) continue;
                boolean success = HttpHelper.postData(jsonArray.toString());
                if (success) {
                    FileHelper.deleteLines(jsonArray.length());
                    jsonArray = new JSONArray();
                    EALog.d("-> properties tracked !", true);
                    continue;
                }
                EALog.d("-> synchronization failed. Will retry later.");
                return -1;
            }
            catch (JSONException e) {
                EALog.e("Failed to JSON encode properties : " + line + ". Exception: " + (Object)((Object)e));
            }
        } while (++counter < storedProperties.size());
        return counter;
    }
}

