/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.os.Handler;
import com.eulerian.android.sdk.ConnectivityHelper;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAProperties;
import com.eulerian.android.sdk.EAnalytics;
import com.eulerian.android.sdk.FileHelper;
import com.eulerian.android.sdk.HttpHelper;
import com.eulerian.android.sdk.JSONUtils;
import com.eulerian.android.sdk.PersistentIdentity;
import com.eulerian.android.sdk.StoredPropertiesTracker;
import java.util.List;

class PropertiesTracker
implements Runnable {
    private final Handler handler;
    private final EAProperties properties;

    PropertiesTracker(EAProperties properties, Handler ui) {
        this.properties = properties;
        this.handler = ui;
    }

    @Override
    public void run() {
        this.handler.removeMessages(1);
        if (PersistentIdentity.getInstance().shouldSendInstallReferrer()) {
            String installReferrer = PersistentIdentity.getInstance().getInstallReferrer();
            EALog.d("Tracking properties for the first time, add install referrer to it");
            JSONUtils.put(this.properties.mProperties, "ea-android-referrer", installReferrer);
            PersistentIdentity.getInstance().setInstallReferrerSent();
        }
        String propertiesToString = this.properties.getJson().toString();
        EALog.d("Tracking properties");
        if (!ConnectivityHelper.isConnected(EAnalytics.getContext())) {
            EALog.d("-> no network access. Properties is being stored and will be sent later.", true);
            FileHelper.appendLine(propertiesToString);
            this.handler.sendEmptyMessageDelayed(1, 60000L);
            return;
        }
        List<String> storedProperties = FileHelper.getLines();
        if (storedProperties.isEmpty()) {
            boolean success = HttpHelper.postData("[" + propertiesToString + "]");
            if (!success) {
                EALog.d("-> synchronization failed. Will retry if no other pending track is found.");
                FileHelper.appendLine(propertiesToString);
                this.handler.sendEmptyMessageDelayed(1, 5000L);
            } else {
                EALog.d("-> properties tracked !", true);
            }
            return;
        }
        EALog.d("-> " + storedProperties.size() + " stored properties found, current properties added to history to be sent with stored ones.");
        FileHelper.appendLine(propertiesToString);
        new StoredPropertiesTracker(this.handler).run();
    }
}

