/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.JSONUtils;
import com.eulerian.android.sdk.Params;
import org.json.JSONObject;

public class Product {
    private static final String KEY_REF = "ref";
    private static final String KEY_NAME = "name";
    private static final String KEY_PARAMS = "params";
    private static final String KEY_GROUP = "group";
    private JSONObject mJson;

    protected Product(Builder builder) {
        this.mJson = builder.mainJson;
    }

    public JSONObject getJson() {
        return this.mJson;
    }

    public static class Builder {
        private final JSONObject mainJson = new JSONObject();

        public Builder(String reference) {
            JSONUtils.put(this.mainJson, Product.KEY_REF, reference);
        }

        public Builder setName(String name) {
            JSONUtils.put(this.mainJson, Product.KEY_NAME, name);
            return this;
        }

        public Builder setGroup(String group) {
            JSONUtils.put(this.mainJson, Product.KEY_GROUP, group);
            return this;
        }

        public Builder setParams(Params params) {
            JSONUtils.put(this.mainJson, Product.KEY_PARAMS, params.getJson());
            return this;
        }

        public Product build() {
            return new Product(this);
        }
    }
}

