/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import com.eulerian.android.sdk.EAnalytics;

class PersistentIdentity {
    private static final String INSTALL_REFERRER_HAS_ALREADY_BEEN_SENT_ONCE = "referrer_sent_v1_8_0";
    private static PersistentIdentity mInstance;
    private final SharedPreferences mSharedPreferences = EAnalytics.getContext().getSharedPreferences("eanalytics-prefs", 0);
    static final String KEY_REFERRER = "referrer";
    static final String KEY_ADVERTISING_ID = "id";
    static final String KEY_ADVERTISING_IS_LAT = "isLAT";

    public static PersistentIdentity getInstance() {
        if (mInstance == null) {
            mInstance = new PersistentIdentity();
        }
        return mInstance;
    }

    private PersistentIdentity() {
    }

    public String getAdvertisingId() {
        return this.mSharedPreferences.getString(KEY_ADVERTISING_ID, null);
    }

    public boolean getAdvertisingIsLat() {
        return this.mSharedPreferences.getBoolean(KEY_ADVERTISING_IS_LAT, false);
    }

    public synchronized void saveAdvertisingId(String id, boolean isLAT) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_ADVERTISING_ID, id);
        editor.putBoolean(KEY_ADVERTISING_IS_LAT, isLAT);
        this.writeEdits(editor);
    }

    private void writeEdits(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public void saveInstallReferrer(@NonNull String referrer) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(KEY_REFERRER, referrer);
        this.writeEdits(editor);
    }

    public String getInstallReferrer() {
        return this.mSharedPreferences.getString(KEY_REFERRER, null);
    }

    boolean shouldFetchInstallReferrer() {
        boolean isInstallReferrerSent = this.mSharedPreferences.getBoolean(INSTALL_REFERRER_HAS_ALREADY_BEEN_SENT_ONCE, false);
        return !isInstallReferrerSent;
    }

    public boolean shouldSendInstallReferrer() {
        boolean isInstallReferrerSent = this.mSharedPreferences.getBoolean(INSTALL_REFERRER_HAS_ALREADY_BEEN_SENT_ONCE, false);
        boolean isInstallReferrerAvailable = this.getInstallReferrer() != null;
        return isInstallReferrerAvailable && !isInstallReferrerSent;
    }

    public void setInstallReferrerSent() {
        this.mSharedPreferences.edit().putBoolean(INSTALL_REFERRER_HAS_ALREADY_BEEN_SENT_ONCE, true).apply();
    }
}

