/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.content.Context;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.PersistentIdentity;

class InstallReferrerManager {
    InstallReferrerManager() {
    }

    static void startConnection(Context context) {
        final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)context).build();
        referrerClient.startConnection(new InstallReferrerStateListener(){

            public void onInstallReferrerSetupFinished(int responseCode) {
                switch (responseCode) {
                    case 0: {
                        EALog.d("Install referrer setup is OK.");
                        try {
                            ReferrerDetails response = referrerClient.getInstallReferrer();
                            String referrerUrl = response.getInstallReferrer();
                            PersistentIdentity.getInstance().saveInstallReferrer(referrerUrl);
                        }
                        catch (RemoteException remoteException) {}
                        break;
                    }
                    case 2: {
                        EALog.d("Install referrer is not supported.");
                        break;
                    }
                    case 1: {
                        EALog.d("Install referrer: service is unavailable.");
                    }
                }
            }

            public void onInstallReferrerServiceDisconnected() {
            }
        });
    }
}

