/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAnalytics;
import com.eulerian.android.sdk.Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

class HttpHelper {
    HttpHelper() {
    }

    public static boolean postData(String value) {
        EALog.d("-> posting data : " + value);
        try {
            URL url = new URL(EAnalytics.sRTDomain + System.currentTimeMillis() / 1000L);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Encoding", "gzip");
            conn.addRequestProperty("Content-Type", "application/json");
            conn.setReadTimeout(2000);
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(value.getBytes());
            gos.close();
            baos.writeTo(conn.getOutputStream());
            conn.connect();
            if (conn.getResponseCode() == 200) {
                CharSequence response = Helper.toString(conn.getInputStream());
                EALog.d("-> post response: " + response);
                JSONObject json = new JSONObject(response.toString());
                return !json.getBoolean("error");
            }
            return false;
        }
        catch (IOException | JSONException e) {
            EALog.e("postData failed : " + e);
            return false;
        }
    }
}

