/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.app.UiModeManager;
import android.content.Context;
import android.os.Build;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Helper {
    private static final String HOST_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";

    Helper() {
    }

    static boolean isPermissionGranted(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    static boolean isHostValid(String domain) {
        Matcher contentMatcher = Pattern.compile(HOST_REGEX).matcher(domain);
        return contentMatcher.find();
    }

    public static CharSequence toString(InputStream is) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            StringBuilder total = new StringBuilder(is.available());
            while ((line = r.readLine()) != null) {
                total.append(line);
            }
            return total;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean androidTV(Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        return Build.VERSION.SDK_INT >= 13 && uiModeManager.getCurrentModeType() == 4;
    }
}

