/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAProperties;
import com.eulerian.android.sdk.Helper;
import com.eulerian.android.sdk.InstallReferrerManager;
import com.eulerian.android.sdk.PersistentIdentity;
import com.eulerian.android.sdk.PropertiesTracker;
import com.eulerian.android.sdk.StoredPropertiesTracker;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class EAnalytics {
    protected static final int HANDLER_MESSAGE_RETRY = 1;
    private static final String TAG = EAnalytics.class.getSimpleName();
    static String sRTDomain;
    @Nullable
    static String sAdInfoId;
    static boolean sAdInfoIsLAT;
    private static EAnalytics sInstance;
    private static Context sAppContext;
    protected Executor mExecutor = Executors.newSingleThreadExecutor();
    protected Handler mUiHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    EALog.d("Retry strategy");
                    EAnalytics.getInstance().track(null);
                }
            }
        }
    };

    private EAnalytics() {
    }

    public static EAnalytics getInstance() {
        if (sInstance == null) {
            sInstance = new EAnalytics();
        }
        return sInstance;
    }

    public static String getSDKVersion() {
        return "1.9.0";
    }

    public static String getEuidl() {
        ContentResolver contentResolver = EAnalytics.getContext().getContentResolver();
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static void init(Context context, String host, boolean log) {
        EALog.LOG_ENABLED = log;
        EALog.assertCondition(sAppContext == null && sRTDomain == null, "Init must be called only once.");
        EALog.assertCondition(!host.contains(".eulerian.com"), "Host cannot contain '.eulerian.com'.");
        EALog.assertCondition(Helper.isPermissionGranted(context, "android.permission.INTERNET"), "Init failed : permission is missing. You must add permission android.permission.INTERNET in your app Manifest.xml.");
        EALog.assertCondition(Helper.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE"), "Init failed : permission is missing: Your must add permission android.permission.ACCESS_NETWORK_STATE in your app Manifest.xml");
        EALog.assertCondition(Helper.isPermissionGranted(context, "android.permission.ACCESS_WIFI_STATE"), "Init failed : permission is missing: Your must add permission android.permission.ACCESS_WIFI_STATE in your app Manifest.xml");
        EALog.assertCondition(context != null, "Init failed : context is null. You must provide a valid context.");
        EALog.assertCondition(Helper.isHostValid(host), "Init failed : " + host + " is not a valid host name. For instance, test.example.net is a valid.");
        sAppContext = context;
        sRTDomain = "https://" + host + "/collectorjson/-/";
        sAdInfoId = PersistentIdentity.getInstance().getAdvertisingId();
        sAdInfoIsLAT = PersistentIdentity.getInstance().getAdvertisingIsLat();
        EALog.d("SDK initialized with " + host, true);
        EAnalytics.getInstance().mExecutor.execute(new GetAdInfo());
        EAnalytics.getInstance().track(null);
        if (PersistentIdentity.getInstance().shouldFetchInstallReferrer()) {
            InstallReferrerManager.startConnection(context);
        }
    }

    static Context getContext() {
        EALog.assertCondition(sAppContext != null, "The SDK has not been initialized. You must call EAnalytics.init(Context, String) once.");
        return sAppContext;
    }

    public void track(EAProperties properties) {
        EALog.d("track");
        EALog.assertCondition(sRTDomain != null, "The SDK has not been initialized. You must call EAnalytics.init(Context, String) once.");
        if (properties == null) {
            this.mExecutor.execute(new StoredPropertiesTracker(this.mUiHandler));
        } else {
            this.mExecutor.execute(new PropertiesTracker(properties, this.mUiHandler));
        }
    }

    static {
        sAdInfoIsLAT = false;
    }

    static class GetAdInfo
    implements Runnable {
        GetAdInfo() {
        }

        @Override
        public void run() {
            AdvertisingIdClient.Info adInfo = null;
            try {
                adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)EAnalytics.getContext());
            }
            catch (IOException e) {
                EALog.w("Unrecoverable error connecting to Google Play services (e.g. the old version of the service doesn't support getting AdvertisingId)");
            }
            catch (GooglePlayServicesRepairableException e) {
                EALog.w("Google Play Services is not installed, up-to-date, or enabled");
            }
            catch (GooglePlayServicesNotAvailableException e) {
                EALog.w("Google Play services is not available entirely.");
            }
            if (adInfo == null) {
                EALog.d("AdvertisingIdClient has not been found");
                return;
            }
            sAdInfoId = adInfo.getId();
            sAdInfoIsLAT = adInfo.isLimitAdTrackingEnabled();
            PersistentIdentity.getInstance().saveAdvertisingId(sAdInfoId, sAdInfoIsLAT);
            EALog.d("AdvertisingIdClient id and isLat found");
        }
    }
}

