/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.CurrencyISO;
import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.EAProperties;
import com.eulerian.android.sdk.JSONUtils;
import com.eulerian.android.sdk.Product;
import org.json.JSONArray;
import org.json.JSONObject;

public class EAOrder
extends EAProperties {
    private static final String KEY_REF = "ref";
    private static final String KEY_SALE_AMOUNT = "amount";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_ESTIMATE_REF = "estimateref";
    private static final String KEY_TYPE = "type";
    private static final String KEY_PAYMENT = "payment";
    private static final String KEY_PRODUCTS = "products";
    private static final String KEY_PRODUCT_AMOUNT = "amount";
    private static final String KEY_PRODUCT_QUANTITY = "quantity";

    protected EAOrder(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends EAProperties.Builder<Builder> {
        private final JSONArray products = new JSONArray();

        public Builder(String path, String ref) {
            super(path);
            this.set(EAOrder.KEY_REF, ref);
        }

        public Builder setAmount(double amount) {
            this.set("amount", String.valueOf(amount));
            return this;
        }

        public Builder setCurrency(String currency) {
            this.set(EAOrder.KEY_CURRENCY, currency);
            return this;
        }

        public Builder setCurrency(CurrencyISO currency) {
            this.set(EAOrder.KEY_CURRENCY, currency.value);
            return this;
        }

        public Builder setType(String type) {
            this.set(EAOrder.KEY_TYPE, type);
            return this;
        }

        public Builder setPayment(String payment) {
            this.set(EAOrder.KEY_PAYMENT, payment);
            return this;
        }

        public Builder setEstimateRef(String estimateRef) {
            this.set(EAOrder.KEY_ESTIMATE_REF, estimateRef);
            return this;
        }

        public Builder addProduct(Product product, double amount, int quantity) {
            if (quantity <= 0) {
                EALog.w(EAOrder.class.getSimpleName() + "#addProduct() : quantity might be > 0. Current is " + quantity);
            }
            JSONObject productJson = product.getJson();
            JSONUtils.put(productJson, "amount", amount);
            JSONUtils.put(productJson, EAOrder.KEY_PRODUCT_QUANTITY, quantity);
            this.products.put((Object)productJson);
            return this;
        }

        @Override
        public EAOrder build() {
            JSONUtils.put(this.properties, EAOrder.KEY_PRODUCTS, this.products);
            return new EAOrder(this);
        }
    }
}

