/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.EAProperties;
import com.eulerian.android.sdk.JSONUtils;
import com.eulerian.android.sdk.Product;
import org.json.JSONArray;
import org.json.JSONObject;

public class EACart
extends EAProperties {
    private static final String KEY_SCART = "scart";
    private static final String KEY_CUMUL = "scartcumul";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_QUANTITY = "quantity";
    private static final String KEY_PRODUCTS = "products";

    protected EACart(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends EAProperties.Builder<Builder> {
        private final JSONArray products = new JSONArray();

        public Builder(String path) {
            super(path);
            this.set(EACart.KEY_SCART, "1");
        }

        public Builder setCartCumul(boolean cumul) {
            this.set(EACart.KEY_CUMUL, cumul ? 1 : 0);
            return this;
        }

        public Builder addProduct(Product product, double amount, int quantity) {
            JSONObject productJson = product.getJson();
            JSONUtils.put(productJson, EACart.KEY_AMOUNT, amount);
            JSONUtils.put(productJson, EACart.KEY_QUANTITY, quantity);
            this.products.put((Object)productJson);
            return this;
        }

        @Override
        public EACart build() {
            JSONUtils.put(this.properties, EACart.KEY_PRODUCTS, this.products);
            return new EACart(this);
        }
    }
}

