/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.squirrelid.resolver;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.enginehub.squirrelid.Profile;
import org.enginehub.squirrelid.resolver.SingleRequestService;

public class BukkitPlayerService
extends SingleRequestService {
    private static final BukkitPlayerService INSTANCE = new BukkitPlayerService();

    private BukkitPlayerService() {
    }

    public static BukkitPlayerService getInstance() {
        return INSTANCE;
    }

    @Override
    public int getIdealRequestLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public Profile findByName(String name) throws IOException, InterruptedException {
        Player player = Bukkit.getServer().getPlayerExact(name);
        if (player != null) {
            return new Profile(player.getUniqueId(), player.getName());
        }
        return null;
    }

    @Override
    @Nullable
    public Profile findByUuid(UUID uuid) throws IOException, InterruptedException {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        if (player.getName() != null) {
            return new Profile(player.getUniqueId(), player.getName());
        }
        return null;
    }
}

