/*
 * Decompiled with CFR 0.152.
 */
package co.amity.rxupload.internal.datastore;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.webkit.MimeTypeMap;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscriber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lco/amity/rxupload/internal/datastore/FileLocalDataStore;", "", "()V", "cacheDirectory", "", "clearCache", "Lio/reactivex/Completable;", "context", "Landroid/content/Context;", "fileFromUri", "Ljava/io/File;", "uri", "Landroid/net/Uri;", "fileNameFromUri", "fileSizeFromUri", "", "(Landroid/content/Context;Landroid/net/Uri;)Ljava/lang/Long;", "getFile", "Lio/reactivex/Single;", "getFileName", "getFileSize", "getMimeType", "isContent", "", "isDocument", "isFile", "mimeTypeFromUri", "rxupload_release"})
public final class FileLocalDataStore {
    @NotNull
    private final String cacheDirectory;

    public FileLocalDataStore() {
        this.cacheDirectory = "AMITY_RX_UPLOAD_SERVICE_CACHE";
    }

    private final boolean isFile(Uri uri) {
        return uri.getScheme() == null || Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file");
    }

    private final boolean isContent(Uri uri) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content");
    }

    private final boolean isDocument(Context context, Uri uri) {
        return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
    }

    private final String mimeTypeFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            String string = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileExtensionFromUrl(uri.toString())");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            String extension = string3;
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return context.getContentResolver().getType(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fileNameFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            String string;
            String string2 = uri.getPath();
            if (string2 == null) {
                string = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = new File(it).getName();
            }
            return string;
        }
        Object object = new String[]{"_display_name"};
        Cursor cursor = context.getContentResolver().query(uri, object, null, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)object;
                boolean bl5 = false;
                if (it.moveToFirst()) {
                    String string = it.getString(it.getColumnIndex("_display_name"));
                    return string;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Long fileSizeFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            Long l;
            String string = uri.getPath();
            if (string == null) {
                l = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                l = new File(it).length();
            }
            return l;
        }
        Object object = new String[]{"_size"};
        Cursor cursor = context.getContentResolver().query(uri, object, null, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            boolean bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)object;
                boolean bl5 = false;
                if (it.moveToFirst()) {
                    Long l = it.getLong(it.getColumnIndex("_size"));
                    return l;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File fileFromUri(Context context, Uri uri) {
        Object object;
        if (this.isFile(uri)) {
            File file;
            String string = uri.getPath();
            if (string == null) {
                file = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                file = new File(it);
            }
            return file;
        }
        try {
            File file;
            object = context.getContentResolver().openInputStream(uri);
            if (object == null) {
                file = null;
            } else {
                Closeable closeable = (Closeable)object;
                boolean bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    File output;
                    InputStream it = (InputStream)closeable;
                    boolean bl5 = false;
                    File directory = new File(context.getCacheDir(), this.cacheDirectory);
                    directory.mkdirs();
                    File file2 = output = new File(directory, UUID.randomUUID().toString());
                    boolean bl6 = false;
                    ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)new FileOutputStream(file2), (int)0, (int)2, null);
                    File file3 = output;
                    file = file3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            object = file;
        }
        catch (FileNotFoundException e) {
            object = null;
        }
        return object;
    }

    @NotNull
    public final Single<String> getMimeType(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Single single = Single.fromPublisher(arg_0 -> FileLocalDataStore.getMimeType$lambda-8(this, context, uri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromPublisher {\n            mimeTypeFromUri(context, uri)\n                ?.let { mimeType ->\n                    it.onNext(mimeType)\n                    it.onComplete()\n                } ?: run { it.onError(FileNotFoundException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<String> getFileName(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Single single = Single.fromPublisher(arg_0 -> FileLocalDataStore.getFileName$lambda-11(this, context, uri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromPublisher {\n            fileNameFromUri(context, uri)\n                ?.let { fileName ->\n                    it.onNext(fileName)\n                    it.onComplete()\n                } ?: run { it.onError(FileNotFoundException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<Long> getFileSize(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Single single = Single.fromPublisher(arg_0 -> FileLocalDataStore.getFileSize$lambda-14(this, context, uri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromPublisher {\n            fileSizeFromUri(context, uri)\n                ?.let { fileSize ->\n                    it.onNext(fileSize)\n                    it.onComplete()\n                } ?: run { it.onError(FileNotFoundException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<File> getFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Single single = Single.fromPublisher(arg_0 -> FileLocalDataStore.getFile$lambda-17(this, context, uri, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromPublisher {\n            fileFromUri(context, uri)\n                ?.let { file ->\n                    it.onNext(file)\n                    it.onComplete()\n                } ?: run { it.onError(FileNotFoundException()) }\n        }");
        return single;
    }

    @NotNull
    public final Completable clearCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Completable completable = Completable.fromAction(() -> FileLocalDataStore.clearCache$lambda-18(context, this));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n            val directory = File(context.cacheDir, cacheDirectory)\n            directory.deleteRecursively()\n        }");
        return completable;
    }

    private static final void getMimeType$lambda-8(FileLocalDataStore this$0, Context $context, Uri $uri, Subscriber it) {
        block2: {
            Unit unit;
            boolean bl;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Object object = this$0.mimeTypeFromUri($context, $uri);
            if (object == null) {
                unit2 = null;
            } else {
                String string = object;
                bl = false;
                boolean bl2 = false;
                String mimeType = string;
                boolean bl3 = false;
                it.onNext((Object)mimeType);
                it.onComplete();
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            object = this$0;
            boolean bl4 = false;
            bl = false;
            Object $this$getMimeType_u24lambda_u2d8_u24lambda_u2d7 = object;
            boolean bl5 = false;
            it.onError((Throwable)new FileNotFoundException());
        }
    }

    private static final void getFileName$lambda-11(FileLocalDataStore this$0, Context $context, Uri $uri, Subscriber it) {
        block2: {
            Unit unit;
            boolean bl;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Object object = this$0.fileNameFromUri($context, $uri);
            if (object == null) {
                unit2 = null;
            } else {
                String string = object;
                bl = false;
                boolean bl2 = false;
                String fileName = string;
                boolean bl3 = false;
                it.onNext((Object)fileName);
                it.onComplete();
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            object = this$0;
            boolean bl4 = false;
            bl = false;
            Object $this$getFileName_u24lambda_u2d11_u24lambda_u2d10 = object;
            boolean bl5 = false;
            it.onError((Throwable)new FileNotFoundException());
        }
    }

    private static final void getFileSize$lambda-14(FileLocalDataStore this$0, Context $context, Uri $uri, Subscriber it) {
        block2: {
            Unit unit;
            boolean bl;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Object object = this$0.fileSizeFromUri($context, $uri);
            if (object == null) {
                unit2 = null;
            } else {
                Long l = object;
                bl = false;
                boolean bl2 = false;
                long fileSize = ((Number)l).longValue();
                boolean bl3 = false;
                it.onNext((Object)fileSize);
                it.onComplete();
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            object = this$0;
            boolean bl4 = false;
            bl = false;
            Object $this$getFileSize_u24lambda_u2d14_u24lambda_u2d13 = object;
            boolean bl5 = false;
            it.onError((Throwable)new FileNotFoundException());
        }
    }

    private static final void getFile$lambda-17(FileLocalDataStore this$0, Context $context, Uri $uri, Subscriber it) {
        block2: {
            Unit unit;
            boolean bl;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Object object = this$0.fileFromUri($context, $uri);
            if (object == null) {
                unit2 = null;
            } else {
                File file = object;
                bl = false;
                boolean bl2 = false;
                File file2 = file;
                boolean bl3 = false;
                it.onNext((Object)file2);
                it.onComplete();
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            object = this$0;
            boolean bl4 = false;
            bl = false;
            Object $this$getFile_u24lambda_u2d17_u24lambda_u2d16 = object;
            boolean bl5 = false;
            it.onError((Throwable)new FileNotFoundException());
        }
    }

    private static final void clearCache$lambda-18(Context $context, FileLocalDataStore this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        File directory = new File($context.getCacheDir(), this$0.cacheDirectory);
        FilesKt.deleteRecursively((File)directory);
    }
}

