/*
 * Decompiled with CFR 0.152.
 */
package co.amity.rxupload.internal.datastore;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.util.Log;
import android.webkit.MimeTypeMap;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lco/amity/rxupload/internal/datastore/FileLocalDataStore;", "", "()V", "cacheDirectory", "", "clearCache", "Lio/reactivex/Completable;", "context", "Landroid/content/Context;", "fileFromUri", "Ljava/io/File;", "uri", "Landroid/net/Uri;", "fileNameFromUri", "fileSizeFromUri", "", "(Landroid/content/Context;Landroid/net/Uri;)Ljava/lang/Long;", "getFile", "Lio/reactivex/Single;", "getFileName", "getFileSize", "getMimeType", "isContent", "", "isDocument", "isFile", "mimeTypeFromUri", "test", "rxupload_release"})
public final class FileLocalDataStore {
    private final String cacheDirectory = "AMITY_RX_UPLOAD_SERVICE_CACHE";

    private final boolean isFile(Uri uri) {
        return uri.getScheme() == null || Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file");
    }

    private final boolean isContent(Uri uri) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content");
    }

    private final boolean isDocument(Context context, Uri uri) {
        return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
    }

    private final String mimeTypeFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            String string = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MimeTypeMap.getFileExten\u2026onFromUrl(uri.toString())");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            String extension = string4;
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return context.getContentResolver().getType(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fileNameFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            String string;
            String string2 = uri.getPath();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = new File(it).getName();
            } else {
                string = null;
            }
            return string;
        }
        Cursor cursor = context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl5 = false;
                if (it.moveToFirst()) {
                    String string = it.getString(it.getColumnIndex("_display_name"));
                    return string;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Long fileSizeFromUri(Context context, Uri uri) {
        if (this.isFile(uri)) {
            Long l;
            String string = uri.getPath();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                l = new File(it).length();
            } else {
                l = null;
            }
            return l;
        }
        Cursor cursor = context.getContentResolver().query(uri, new String[]{"_size"}, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl5 = false;
                if (it.moveToFirst()) {
                    Long l = it.getLong(it.getColumnIndex("_size"));
                    return l;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File fileFromUri(Context context, Uri uri) {
        Closeable closeable;
        if (this.isFile(uri)) {
            File file;
            String string = uri.getPath();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                file = new File(it);
            } else {
                file = null;
            }
            return file;
        }
        try {
            File file;
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                closeable = inputStream;
                boolean bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl5 = false;
                    File directory = new File(context.getCacheDir(), this.cacheDirectory);
                    directory.mkdirs();
                    File output = new File(directory, UUID.randomUUID().toString());
                    InputStream inputStream2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"it");
                    File file2 = output;
                    InputStream inputStream3 = inputStream2;
                    boolean bl6 = false;
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ByteStreamsKt.copyTo$default((InputStream)inputStream3, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                    File file3 = output;
                    file = file3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                file = null;
            }
            closeable = file;
        }
        catch (FileNotFoundException e) {
            closeable = null;
        }
        return closeable;
    }

    @NotNull
    public final Single<String> getMimeType(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Single single = Single.fromPublisher((Publisher)new Publisher<T>(this, context, uri){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Uri $uri;

            public final void subscribe(Subscriber<? super String> it) {
                String string = FileLocalDataStore.access$mimeTypeFromUri(this.this$0, this.$context, this.$uri);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String mimeType = string2;
                    boolean bl3 = false;
                    Log.e((String)"testtest", (String)("mimeType:" + mimeType));
                    it.onNext((Object)mimeType);
                    it.onComplete();
                } else {
                    FileLocalDataStore fileLocalDataStore = this.this$0;
                    boolean bl = false;
                    boolean bl4 = false;
                    FileLocalDataStore $this$run = fileLocalDataStore;
                    boolean bl5 = false;
                    it.onError((Throwable)new FileNotFoundException());
                }
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$context = context;
                this.$uri = uri;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromPublisher {\n \u2026dException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<String> getFileName(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Single single = Single.fromPublisher((Publisher)new Publisher<T>(this, context, uri){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Uri $uri;

            public final void subscribe(Subscriber<? super String> it) {
                String string = FileLocalDataStore.access$fileNameFromUri(this.this$0, this.$context, this.$uri);
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String fileName = string2;
                    boolean bl3 = false;
                    Log.e((String)"testtest", (String)("fileName:" + fileName));
                    it.onNext((Object)fileName);
                    it.onComplete();
                } else {
                    FileLocalDataStore fileLocalDataStore = this.this$0;
                    boolean bl = false;
                    boolean bl4 = false;
                    FileLocalDataStore $this$run = fileLocalDataStore;
                    boolean bl5 = false;
                    it.onError((Throwable)new FileNotFoundException());
                }
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$context = context;
                this.$uri = uri;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromPublisher {\n \u2026dException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<Long> getFileSize(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Single single = Single.fromPublisher((Publisher)new Publisher<T>(this, context, uri){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Uri $uri;

            public final void subscribe(Subscriber<? super Long> it) {
                Long l = FileLocalDataStore.access$fileSizeFromUri(this.this$0, this.$context, this.$uri);
                if (l != null) {
                    Long l2 = l;
                    boolean bl = false;
                    boolean bl2 = false;
                    long fileSize = ((Number)l2).longValue();
                    boolean bl3 = false;
                    Log.e((String)"testtest", (String)("fileSize:" + fileSize));
                    it.onNext((Object)fileSize);
                    it.onComplete();
                } else {
                    FileLocalDataStore fileLocalDataStore = this.this$0;
                    boolean bl = false;
                    boolean bl4 = false;
                    FileLocalDataStore $this$run = fileLocalDataStore;
                    boolean bl5 = false;
                    it.onError((Throwable)new FileNotFoundException());
                }
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$context = context;
                this.$uri = uri;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromPublisher {\n \u2026dException()) }\n        }");
        return single;
    }

    @NotNull
    public final Single<File> getFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Single single = Single.fromPublisher((Publisher)new Publisher<T>(this, context, uri){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Uri $uri;

            public final void subscribe(Subscriber<? super File> it) {
                File file = FileLocalDataStore.access$fileFromUri(this.this$0, this.$context, this.$uri);
                if (file != null) {
                    File file2 = file;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file3 = file2;
                    boolean bl3 = false;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "path:%s absolutePath:%s exists:%s";
                    Object[] objectArray = new Object[]{file3.getPath(), file3.getAbsolutePath(), file3.exists()};
                    String string2 = "testtest";
                    boolean bl4 = false;
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    String string4 = string3;
                    Log.e((String)string2, (String)string4);
                    it.onNext((Object)file3);
                    it.onComplete();
                } else {
                    FileLocalDataStore fileLocalDataStore = this.this$0;
                    boolean bl = false;
                    boolean bl5 = false;
                    FileLocalDataStore $this$run = fileLocalDataStore;
                    boolean bl6 = false;
                    it.onError((Throwable)new FileNotFoundException());
                }
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$context = context;
                this.$uri = uri;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromPublisher {\n \u2026dException()) }\n        }");
        return single;
    }

    @NotNull
    public final Completable test(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Completable completable = Completable.fromAction((Action)new Action(this, uri, context){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ Context $context;

            public final void run() {
                Log.e((String)"testtest", (String)("uri:" + this.$uri.getPath()));
                Log.e((String)"testtest", (String)("uri:" + this.$uri));
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "isFile:%s isContent:%s :isDocument:%s";
                Object[] objectArray = new Object[]{FileLocalDataStore.access$isFile(this.this$0, this.$uri), FileLocalDataStore.access$isContent(this.this$0, this.$uri), FileLocalDataStore.access$isDocument(this.this$0, this.$context, this.$uri)};
                String string2 = "testtest";
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                Log.e((String)string2, (String)string4);
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$uri = uri;
                this.$context = context;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026)\n            )\n        }");
        return completable;
    }

    @NotNull
    public final Completable clearCache(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Completable completable = Completable.fromAction((Action)new Action(this, context){
            final /* synthetic */ FileLocalDataStore this$0;
            final /* synthetic */ Context $context;

            public final void run() {
                File directory = new File(this.$context.getCacheDir(), FileLocalDataStore.access$getCacheDirectory$p(this.this$0));
                FilesKt.deleteRecursively((File)directory);
                Log.e((String)"testtest", (String)"deleteRecursively");
            }
            {
                this.this$0 = fileLocalDataStore;
                this.$context = context;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromAction {\u2026teRecursively\")\n        }");
        return completable;
    }

    public static final /* synthetic */ String access$mimeTypeFromUri(FileLocalDataStore $this, Context context, Uri uri) {
        return $this.mimeTypeFromUri(context, uri);
    }

    public static final /* synthetic */ String access$fileNameFromUri(FileLocalDataStore $this, Context context, Uri uri) {
        return $this.fileNameFromUri(context, uri);
    }

    public static final /* synthetic */ Long access$fileSizeFromUri(FileLocalDataStore $this, Context context, Uri uri) {
        return $this.fileSizeFromUri(context, uri);
    }

    public static final /* synthetic */ File access$fileFromUri(FileLocalDataStore $this, Context context, Uri uri) {
        return $this.fileFromUri(context, uri);
    }

    public static final /* synthetic */ boolean access$isFile(FileLocalDataStore $this, Uri uri) {
        return $this.isFile(uri);
    }

    public static final /* synthetic */ boolean access$isContent(FileLocalDataStore $this, Uri uri) {
        return $this.isContent(uri);
    }

    public static final /* synthetic */ boolean access$isDocument(FileLocalDataStore $this, Context context, Uri uri) {
        return $this.isDocument(context, uri);
    }

    public static final /* synthetic */ String access$getCacheDirectory$p(FileLocalDataStore $this) {
        return $this.cacheDirectory;
    }
}

