/*
 * Decompiled with CFR 0.152.
 */
package com.dylanc.longan;

import android.content.Context;
import android.text.format.Formatter;
import androidx.core.util.PatternsCompat;
import com.dylanc.longan.ApplicationKt;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\b*\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0014\u001a2\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b\u001a2\u0010\u0015\u001a\u00020\u0001*\u00020\u001b2\b\b\u0002\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0004\u001a\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"REGEX_ID_CARD_15", "", "REGEX_ID_CARD_18", "REGEX_PHONE_EXACT", "randomUUIDString", "getRandomUUIDString", "()Ljava/lang/String;", "isDomainName", "", "isEmail", "isIDCard15", "isIDCard18", "isIP", "isJson", "isPhone", "isWebUrl", "limitLength", "length", "", "toFileSizeString", "", "toNumberString", "", "fractionDigits", "minIntDigits", "isGrouping", "isHalfUp", "", "toShortFileSizeString", "longan"})
public final class StringKt {
    @NotNull
    public static final String REGEX_PHONE_EXACT = "^1(3\\d|4[5-9]|5[0-35-9]|6[2567]|7[0-8]|8\\d|9[0-35-9])\\d{8}$";
    @NotNull
    public static final String REGEX_ID_CARD_15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
    @NotNull
    public static final String REGEX_ID_CARD_18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";

    @NotNull
    public static final String getRandomUUIDString() {
        boolean $i$f$getRandomUUIDString = false;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @NotNull
    public static final String toFileSizeString(long $this$toFileSizeString) {
        String string = Formatter.formatFileSize((Context)((Context)ApplicationKt.getApplication()), (long)$this$toFileSizeString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(application, this)");
        return string;
    }

    @NotNull
    public static final String toShortFileSizeString(long $this$toShortFileSizeString) {
        String string = Formatter.formatShortFileSize((Context)((Context)ApplicationKt.getApplication()), (long)$this$toShortFileSizeString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatShortFileSize(application, this)");
        return string;
    }

    @NotNull
    public static final String limitLength(@NotNull String $this$limitLength, int length) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$limitLength, (String)"<this>");
        if ($this$limitLength.length() <= length) {
            string = $this$limitLength;
        } else {
            String string2 = $this$limitLength;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, length);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    public static final boolean isPhone(@NotNull String $this$isPhone) {
        Intrinsics.checkNotNullParameter((Object)$this$isPhone, (String)"<this>");
        String string = REGEX_PHONE_EXACT;
        boolean bl = false;
        return new Regex(string).matches((CharSequence)$this$isPhone);
    }

    public static final boolean isDomainName(@NotNull String $this$isDomainName) {
        Intrinsics.checkNotNullParameter((Object)$this$isDomainName, (String)"<this>");
        return PatternsCompat.DOMAIN_NAME.matcher($this$isDomainName).matches();
    }

    public static final boolean isEmail(@NotNull String $this$isEmail) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmail, (String)"<this>");
        return PatternsCompat.EMAIL_ADDRESS.matcher($this$isEmail).matches();
    }

    public static final boolean isIP(@NotNull String $this$isIP) {
        Intrinsics.checkNotNullParameter((Object)$this$isIP, (String)"<this>");
        return PatternsCompat.IP_ADDRESS.matcher($this$isIP).matches();
    }

    public static final boolean isWebUrl(@NotNull String $this$isWebUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebUrl, (String)"<this>");
        return PatternsCompat.WEB_URL.matcher($this$isWebUrl).matches();
    }

    public static final boolean isIDCard15(@NotNull String $this$isIDCard15) {
        Intrinsics.checkNotNullParameter((Object)$this$isIDCard15, (String)"<this>");
        String string = REGEX_ID_CARD_15;
        boolean bl = false;
        return new Regex(string).matches((CharSequence)$this$isIDCard15);
    }

    public static final boolean isIDCard18(@NotNull String $this$isIDCard18) {
        Intrinsics.checkNotNullParameter((Object)$this$isIDCard18, (String)"<this>");
        String string = REGEX_ID_CARD_18;
        boolean bl = false;
        return new Regex(string).matches((CharSequence)$this$isIDCard18);
    }

    public static final boolean isJson(@NotNull String $this$isJson) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isJson, (String)"<this>");
        try {
            new JSONObject($this$isJson);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String toNumberString(float $this$toNumberString, int fractionDigits, int minIntDigits, boolean isGrouping, boolean isHalfUp) {
        return StringKt.toNumberString((double)$this$toNumberString, fractionDigits, minIntDigits, isGrouping, isHalfUp);
    }

    public static /* synthetic */ String toNumberString$default(float f, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = true;
        }
        return StringKt.toNumberString(f, n, n2, bl, bl2);
    }

    @NotNull
    public static final String toNumberString(double $this$toNumberString, int fractionDigits, int minIntDigits, boolean isGrouping, boolean isHalfUp) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.text.DecimalFormat");
        }
        numberFormat = (DecimalFormat)numberFormat;
        boolean bl = false;
        boolean bl2 = false;
        NumberFormat $this$toNumberString_u24lambda_u2d0 = numberFormat;
        boolean bl3 = false;
        ((DecimalFormat)$this$toNumberString_u24lambda_u2d0).setGroupingUsed(isGrouping);
        ((DecimalFormat)$this$toNumberString_u24lambda_u2d0).setRoundingMode(isHalfUp ? RoundingMode.HALF_UP : RoundingMode.DOWN);
        ((DecimalFormat)$this$toNumberString_u24lambda_u2d0).setMinimumIntegerDigits(minIntDigits);
        ((DecimalFormat)$this$toNumberString_u24lambda_u2d0).setMinimumFractionDigits(fractionDigits);
        ((DecimalFormat)$this$toNumberString_u24lambda_u2d0).setMaximumFractionDigits(fractionDigits);
        String string = numberFormat.format($this$toNumberString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NumberFormat.getInstance\u2026onDigits\n  }.format(this)");
        return string;
    }

    public static /* synthetic */ String toNumberString$default(double d, int n, int n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = true;
        }
        return StringKt.toNumberString(d, n, n2, bl, bl2);
    }
}

