/*
 * Decompiled with CFR 0.152.
 */
package com.dylanc.longan;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.RequiresPermission;
import androidx.lifecycle.LiveData;
import com.dylanc.longan.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u001f\b\u0007\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/dylanc/longan/BluetoothStateLiveData;", "Landroidx/lifecycle/LiveData;", "", "filter", "Lkotlin/Function1;", "Landroid/bluetooth/BluetoothDevice;", "(Lkotlin/jvm/functions/Function1;)V", "receiver", "Lcom/dylanc/longan/BluetoothStateLiveData$BluetoothStateBroadcastReceive;", "onActive", "", "onInactive", "BluetoothStateBroadcastReceive", "longan"})
public final class BluetoothStateLiveData
extends LiveData<Boolean> {
    @Nullable
    private final Function1<BluetoothDevice, Boolean> filter;
    @Nullable
    private BluetoothStateBroadcastReceive receiver;

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public BluetoothStateLiveData(@Nullable Function1<? super BluetoothDevice, Boolean> filter) {
        this.filter = filter;
    }

    public /* synthetic */ BluetoothStateLiveData(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<? super BluetoothDevice, Boolean>)function1);
    }

    protected void onActive() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        if (this.filter != null) {
            intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            intentFilter.addAction("android.bluetooth.BluetoothAdapter.STATE_OFF");
            intentFilter.addAction("android.bluetooth.BluetoothAdapter.STATE_ON");
        }
        this.receiver = new BluetoothStateBroadcastReceive();
        ApplicationKt.getApplication().registerReceiver((BroadcastReceiver)this.receiver, intentFilter);
    }

    protected void onInactive() {
        ApplicationKt.getApplication().unregisterReceiver((BroadcastReceiver)this.receiver);
        this.receiver = null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public BluetoothStateLiveData() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0017R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/dylanc/longan/BluetoothStateLiveData$BluetoothStateBroadcastReceive;", "Landroid/content/BroadcastReceiver;", "(Lcom/dylanc/longan/BluetoothStateLiveData;)V", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "Landroid/content/Intent;", "getBluetoothDevice", "(Landroid/content/Intent;)Landroid/bluetooth/BluetoothDevice;", "bluetoothState", "", "getBluetoothState", "(Landroid/content/Intent;)I", "onReceive", "", "context", "Landroid/content/Context;", "intent", "longan"})
    private final class BluetoothStateBroadcastReceive
    extends BroadcastReceiver {
        public BluetoothStateBroadcastReceive() {
            Intrinsics.checkNotNullParameter((Object)((Object)BluetoothStateLiveData.this), (String)"this$0");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequiresPermission(value="android.permission.BLUETOOTH")
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            String string = intent.getAction();
            if (string == null) return;
            int n = -1;
            switch (string.hashCode()) {
                case -1530327060: {
                    if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                        n = 1;
                    }
                    break;
                }
                case 1821585647: {
                    if (string.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                        n = 2;
                    }
                    break;
                }
                case -301431627: {
                    if (string.equals("android.bluetooth.device.action.ACL_CONNECTED")) {
                        n = 3;
                    }
                    break;
                }
            }
            block5 : switch (n) {
                case 3: {
                    Function1 function1 = BluetoothStateLiveData.this.filter;
                    if (function1 == null) {
                        return;
                    }
                    BluetoothDevice bluetoothDevice = this.getBluetoothDevice(intent);
                    Intrinsics.checkNotNull((Object)bluetoothDevice);
                    if ((Boolean)function1.invoke((Object)bluetoothDevice) != true) return;
                    boolean bl = true;
                    if (!bl) return;
                    BluetoothStateLiveData.this.setValue(true);
                    return;
                }
                case 2: {
                    Function1 function1 = BluetoothStateLiveData.this.filter;
                    if (function1 == null) {
                        return;
                    }
                    BluetoothDevice bluetoothDevice = this.getBluetoothDevice(intent);
                    Intrinsics.checkNotNull((Object)bluetoothDevice);
                    if ((Boolean)function1.invoke((Object)bluetoothDevice) != true) return;
                    boolean bl = true;
                    if (!bl) return;
                    BluetoothStateLiveData.this.setValue(false);
                    return;
                }
                case 1: {
                    int n2 = this.getBluetoothState(intent);
                    switch (n2) {
                        case 10: {
                            BluetoothStateLiveData.this.setValue(false);
                            break block5;
                        }
                        case 12: {
                            if (BluetoothStateLiveData.this.filter != null) return;
                            BluetoothStateLiveData.this.setValue(true);
                        }
                    }
                }
            }
        }

        private final int getBluetoothState(Intent $this$bluetoothState) {
            return $this$bluetoothState.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
        }

        private final BluetoothDevice getBluetoothDevice(Intent $this$bluetoothDevice) {
            return (BluetoothDevice)$this$bluetoothDevice.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        }
    }
}

