/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurTarget;
import eightbitlab.com.blurview.BlurView;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.Noise;
import eightbitlab.com.blurview.RenderScriptBlur;
import eightbitlab.com.blurview.SizeScaler;

@RequiresApi(api=31)
public class RenderNodeBlurController
implements BlurController {
    private final int[] targetLocation = new int[2];
    private final int[] blurViewLocation = new int[2];
    private final BlurView blurView;
    private final BlurTarget target;
    private final RenderNode blurNode = new RenderNode("BlurView node");
    private final float scaleFactor;
    private final boolean applyNoise;
    private Drawable frameClearDrawable;
    private int overlayColor;
    private float blurRadius = 1.0f;
    private boolean enabled = true;
    @Nullable
    private Bitmap cachedBitmap;
    @Nullable
    private RenderScriptBlur fallbackBlur;
    private final ViewTreeObserver.OnPreDrawListener drawListener = () -> {
        this.saveOnScreenLocation();
        this.updateRenderNodeProperties();
        return true;
    };

    public RenderNodeBlurController(@NonNull BlurView blurView, @NonNull BlurTarget target, int overlayColor, float scaleFactor, boolean applyNoise) {
        this.blurView = blurView;
        this.overlayColor = overlayColor;
        this.target = target;
        this.scaleFactor = scaleFactor;
        this.applyNoise = applyNoise;
        blurView.setWillNotDraw(false);
        blurView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
    }

    @Override
    public boolean draw(Canvas canvas) {
        if (!this.enabled) {
            return true;
        }
        this.saveOnScreenLocation();
        if (canvas.isHardwareAccelerated()) {
            this.hardwarePath(canvas);
        } else {
            this.softwarePath(canvas);
        }
        return true;
    }

    private void hardwarePath(Canvas canvas) {
        this.blurNode.setPosition(0, 0, this.target.getWidth(), this.target.getHeight());
        this.updateRenderNodeProperties();
        this.drawSnapshot();
        canvas.save();
        canvas.clipRect(0.0f, 0.0f, (float)this.blurView.getWidth(), (float)this.blurView.getHeight());
        canvas.drawRenderNode(this.blurNode);
        if (this.applyNoise) {
            Noise.apply(canvas, this.blurView.getContext(), this.blurView.getWidth(), this.blurView.getHeight());
        }
        if (this.overlayColor != 0) {
            canvas.drawColor(this.overlayColor);
        }
        canvas.restore();
    }

    private void updateRenderNodeProperties() {
        float layoutTranslationX = -this.getLeft();
        float layoutTranslationY = -this.getTop();
        this.blurNode.setPivotX((float)this.blurView.getWidth() / 2.0f - layoutTranslationX);
        this.blurNode.setPivotY((float)this.blurView.getHeight() / 2.0f - layoutTranslationY);
        this.blurNode.setTranslationX(layoutTranslationX);
        this.blurNode.setTranslationY(layoutTranslationY);
        if (Build.VERSION.SDK_INT == 31) {
            this.applyBlur();
        }
    }

    private void drawSnapshot() {
        RecordingCanvas recordingCanvas = this.blurNode.beginRecording();
        if (this.frameClearDrawable != null) {
            this.frameClearDrawable.draw((Canvas)recordingCanvas);
        }
        recordingCanvas.drawRenderNode(this.target.renderNode);
        this.applyBlur();
        this.blurNode.endRecording();
    }

    private void softwarePath(Canvas canvas) {
        SizeScaler sizeScaler = new SizeScaler(this.scaleFactor);
        SizeScaler.Size original = new SizeScaler.Size(this.blurView.getWidth(), this.blurView.getHeight());
        SizeScaler.Size scaled = sizeScaler.scale(original);
        if (this.cachedBitmap == null || this.cachedBitmap.getWidth() != scaled.width || this.cachedBitmap.getHeight() != scaled.height) {
            this.cachedBitmap = Bitmap.createBitmap((int)scaled.width, (int)scaled.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas softwareCanvas = new Canvas(this.cachedBitmap);
        softwareCanvas.save();
        this.setupCanvasMatrix(softwareCanvas, original, scaled);
        if (this.frameClearDrawable != null) {
            this.frameClearDrawable.draw(canvas);
        }
        try {
            this.target.draw(softwareCanvas);
        }
        catch (Exception e) {
            Log.e((String)"BlurView", (String)"Error during snapshot capturing", (Throwable)e);
        }
        softwareCanvas.restore();
        if (this.fallbackBlur == null) {
            this.fallbackBlur = new RenderScriptBlur(this.blurView.getContext());
        }
        this.fallbackBlur.blur(this.cachedBitmap, this.blurRadius);
        canvas.save();
        canvas.scale((float)original.width / (float)scaled.width, (float)original.height / (float)scaled.height);
        this.fallbackBlur.render(canvas, this.cachedBitmap);
        canvas.restore();
        if (this.applyNoise) {
            Noise.apply(canvas, this.blurView.getContext(), this.blurView.getWidth(), this.blurView.getHeight());
        }
        if (this.overlayColor != 0) {
            canvas.drawColor(this.overlayColor);
        }
    }

    private void setupCanvasMatrix(Canvas canvas, SizeScaler.Size targetSize, SizeScaler.Size scaledSize) {
        float scaleFactorH = (float)targetSize.height / (float)scaledSize.height;
        float scaleFactorW = (float)targetSize.width / (float)scaledSize.width;
        float scaledLeftPosition = (float)(-this.getLeft()) / scaleFactorW;
        float scaledTopPosition = (float)(-this.getTop()) / scaleFactorH;
        canvas.translate(scaledLeftPosition, scaledTopPosition);
        canvas.scale(1.0f / scaleFactorW, 1.0f / scaleFactorH);
    }

    private int getTop() {
        return this.blurViewLocation[1] - this.targetLocation[1];
    }

    private int getLeft() {
        return this.blurViewLocation[0] - this.targetLocation[0];
    }

    @Override
    public void updateBlurViewSize() {
    }

    @Override
    public void destroy() {
        this.blurNode.discardDisplayList();
        if (this.fallbackBlur != null) {
            this.fallbackBlur.destroy();
            this.fallbackBlur = null;
        }
    }

    @Override
    public BlurViewFacade setBlurEnabled(boolean enabled) {
        this.enabled = enabled;
        this.blurView.invalidate();
        return this;
    }

    @Override
    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        this.blurView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        if (enabled) {
            this.blurView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
        }
        return this;
    }

    @Override
    public BlurViewFacade setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.frameClearDrawable = frameClearDrawable;
        return this;
    }

    @Override
    public BlurViewFacade setBlurRadius(float radius) {
        this.blurRadius = radius;
        this.applyBlur();
        return this;
    }

    private void applyBlur() {
        float realBlurRadius = this.blurRadius * this.scaleFactor;
        RenderEffect blur = RenderEffect.createBlurEffect((float)realBlurRadius, (float)realBlurRadius, (Shader.TileMode)Shader.TileMode.CLAMP);
        this.blurNode.setRenderEffect(blur);
    }

    @Override
    public BlurViewFacade setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.blurView.invalidate();
        }
        return this;
    }

    void updateRotation(float rotation) {
        this.blurNode.setRotationZ(-rotation);
    }

    public void updateScaleX(float scaleX) {
        this.blurNode.setScaleX(1.0f / scaleX);
    }

    public void updateScaleY(float scaleY) {
        this.blurNode.setScaleY(1.0f / scaleY);
    }

    private void saveOnScreenLocation() {
        this.target.getLocationOnScreen(this.targetLocation);
        this.blurView.getLocationOnScreen(this.blurViewLocation);
    }
}

