/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.eightbitlab.blurview.R;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurTarget;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.NoOpController;
import eightbitlab.com.blurview.PreDrawBlurController;
import eightbitlab.com.blurview.RenderNodeBlurController;
import eightbitlab.com.blurview.RenderScriptBlur;

public class BlurView
extends FrameLayout {
    BlurController blurController = new NoOpController();
    @ColorInt
    private int overlayColor;
    private boolean blurAutoUpdate = true;

    public BlurView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public BlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public BlurView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BlurView, defStyleAttr, 0);
        this.overlayColor = a.getColor(R.styleable.BlurView_blurOverlayColor, 0);
        a.recycle();
    }

    public void draw(@NonNull Canvas canvas) {
        boolean shouldDraw = this.blurController.draw(canvas);
        if (shouldDraw) {
            super.draw(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.blurController.updateBlurViewSize();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.blurController.setBlurAutoUpdate(false);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.e((String)"BlurView", (String)"BlurView can't be used in not hardware-accelerated window!");
        } else {
            this.blurController.setBlurAutoUpdate(this.blurAutoUpdate);
        }
    }

    public BlurViewFacade setupWith(@NonNull BlurTarget target, BlurAlgorithm algorithm, float scaleFactor, boolean applyNoise) {
        this.blurController.destroy();
        this.blurController = BlurTarget.canUseHardwareRendering ? new RenderNodeBlurController(this, target, this.overlayColor, scaleFactor, applyNoise) : new PreDrawBlurController((View)this, (ViewGroup)target, this.overlayColor, algorithm, scaleFactor, applyNoise);
        return this.blurController;
    }

    public BlurViewFacade setupWith(@NonNull BlurTarget rootView, float scaleFactor, boolean applyNoise) {
        RenderScriptBlur algorithm = BlurTarget.canUseHardwareRendering ? null : new RenderScriptBlur(this.getContext());
        return this.setupWith(rootView, algorithm, scaleFactor, applyNoise);
    }

    public BlurViewFacade setupWith(@NonNull BlurTarget rootView) {
        return this.setupWith(rootView, 4.0f, true);
    }

    public BlurViewFacade setBlurRadius(float radius) {
        return this.blurController.setBlurRadius(radius);
    }

    public BlurViewFacade setOverlayColor(@ColorInt int overlayColor) {
        this.overlayColor = overlayColor;
        return this.blurController.setOverlayColor(overlayColor);
    }

    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        this.blurAutoUpdate = enabled;
        return this.blurController.setBlurAutoUpdate(enabled);
    }

    public BlurViewFacade setBlurEnabled(boolean enabled) {
        return this.blurController.setBlurEnabled(enabled);
    }

    public void setRotation(float rotation) {
        super.setRotation(rotation);
        this.notifyRotationChanged(rotation);
    }

    @SuppressLint(value={"NewApi"})
    public void notifyRotationChanged(float rotation) {
        if (this.usingRenderNode()) {
            ((RenderNodeBlurController)this.blurController).updateRotation(rotation);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void notifyScaleXChanged(float scaleX) {
        if (this.usingRenderNode()) {
            ((RenderNodeBlurController)this.blurController).updateScaleX(scaleX);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void notifyScaleYChanged(float scaleY) {
        if (this.usingRenderNode()) {
            ((RenderNodeBlurController)this.blurController).updateScaleY(scaleY);
        }
    }

    private boolean usingRenderNode() {
        return this.blurController instanceof RenderNodeBlurController;
    }
}

