/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurViewCanvas;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.Noise;
import eightbitlab.com.blurview.SizeScaler;

public final class PreDrawBlurController
implements BlurController {
    @ColorInt
    public static final int TRANSPARENT = 0;
    private float blurRadius = 16.0f;
    private final BlurAlgorithm blurAlgorithm;
    private final float scaleFactor;
    private final boolean applyNoise;
    private BlurViewCanvas internalCanvas;
    private Bitmap internalBitmap;
    final View blurView;
    private int overlayColor;
    private final ViewGroup rootView;
    private final int[] rootLocation = new int[2];
    private final int[] blurViewLocation = new int[2];
    private final ViewTreeObserver.OnPreDrawListener drawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            PreDrawBlurController.this.updateBlur();
            return true;
        }
    };
    private boolean blurEnabled = true;
    private boolean initialized;
    @Nullable
    private Drawable frameClearDrawable;

    public PreDrawBlurController(@NonNull View blurView, @NonNull ViewGroup rootView, @ColorInt int overlayColor, BlurAlgorithm algorithm, float scaleFactor, boolean applyNoise) {
        this.rootView = rootView;
        this.blurView = blurView;
        this.overlayColor = overlayColor;
        this.blurAlgorithm = algorithm;
        this.scaleFactor = scaleFactor;
        this.applyNoise = applyNoise;
        int measuredWidth = blurView.getMeasuredWidth();
        int measuredHeight = blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    void init(int measuredWidth, int measuredHeight) {
        this.setBlurAutoUpdate(true);
        SizeScaler sizeScaler = new SizeScaler(this.scaleFactor);
        if (sizeScaler.isZeroSized(measuredWidth, measuredHeight)) {
            this.blurView.setWillNotDraw(true);
            return;
        }
        this.blurView.setWillNotDraw(false);
        SizeScaler.Size bitmapSize = sizeScaler.scale(measuredWidth, measuredHeight);
        this.internalBitmap = Bitmap.createBitmap((int)bitmapSize.width, (int)bitmapSize.height, (Bitmap.Config)this.blurAlgorithm.getSupportedBitmapConfig());
        this.internalCanvas = new BlurViewCanvas(this.internalBitmap);
        this.initialized = true;
        this.updateBlur();
    }

    void updateBlur() {
        if (!this.blurEnabled || !this.initialized) {
            return;
        }
        if (this.frameClearDrawable == null) {
            this.internalBitmap.eraseColor(0);
        } else {
            this.frameClearDrawable.draw((Canvas)this.internalCanvas);
        }
        this.internalCanvas.save();
        this.setupInternalCanvasMatrix();
        this.rootView.draw((Canvas)this.internalCanvas);
        this.internalCanvas.restore();
        this.blurAndSave();
    }

    private void setupInternalCanvasMatrix() {
        this.rootView.getLocationOnScreen(this.rootLocation);
        this.blurView.getLocationOnScreen(this.blurViewLocation);
        int left = this.blurViewLocation[0] - this.rootLocation[0];
        int top = this.blurViewLocation[1] - this.rootLocation[1];
        float scaleFactorH = (float)this.blurView.getHeight() / (float)this.internalBitmap.getHeight();
        float scaleFactorW = (float)this.blurView.getWidth() / (float)this.internalBitmap.getWidth();
        float scaledLeftPosition = (float)(-left) / scaleFactorW;
        float scaledTopPosition = (float)(-top) / scaleFactorH;
        this.internalCanvas.translate(scaledLeftPosition, scaledTopPosition);
        this.internalCanvas.scale(1.0f / scaleFactorW, 1.0f / scaleFactorH);
    }

    @Override
    public boolean draw(Canvas canvas) {
        if (!this.blurEnabled || !this.initialized) {
            return true;
        }
        if (canvas instanceof BlurViewCanvas) {
            return false;
        }
        float scaleFactorH = (float)this.blurView.getHeight() / (float)this.internalBitmap.getHeight();
        float scaleFactorW = (float)this.blurView.getWidth() / (float)this.internalBitmap.getWidth();
        canvas.save();
        canvas.scale(scaleFactorW, scaleFactorH);
        this.blurAlgorithm.render(canvas, this.internalBitmap);
        canvas.restore();
        if (this.applyNoise) {
            Noise.apply(canvas, this.blurView.getContext(), this.blurView.getWidth(), this.blurView.getHeight());
        }
        if (this.overlayColor != 0) {
            canvas.drawColor(this.overlayColor);
        }
        return true;
    }

    private void blurAndSave() {
        this.internalBitmap = this.blurAlgorithm.blur(this.internalBitmap, this.blurRadius);
        if (!this.blurAlgorithm.canModifyBitmap()) {
            this.internalCanvas.setBitmap(this.internalBitmap);
        }
    }

    @Override
    public void updateBlurViewSize() {
        int measuredWidth = this.blurView.getMeasuredWidth();
        int measuredHeight = this.blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    @Override
    public void destroy() {
        this.setBlurAutoUpdate(false);
        this.blurAlgorithm.destroy();
        this.initialized = false;
    }

    @Override
    public BlurViewFacade setBlurRadius(float radius) {
        this.blurRadius = radius;
        return this;
    }

    @Override
    public BlurViewFacade setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.frameClearDrawable = frameClearDrawable;
        return this;
    }

    @Override
    public BlurViewFacade setBlurEnabled(boolean enabled) {
        this.blurEnabled = enabled;
        this.setBlurAutoUpdate(enabled);
        this.blurView.invalidate();
        return this;
    }

    @Override
    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        this.rootView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        this.blurView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        if (enabled) {
            this.rootView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
            if (this.rootView.getWindowId() != this.blurView.getWindowId()) {
                this.blurView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
            }
        }
        return this;
    }

    @Override
    public BlurViewFacade setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.blurView.invalidate();
        }
        return this;
    }
}

