/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.DefaultBlurController;
import eightbitlab.com.blurview.R;

public class BlurView
extends FrameLayout {
    private static final String TAG = BlurView.class.getSimpleName();
    private BlurController blurController;
    @ColorInt
    private int overlayColor;

    public BlurView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public BlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public BlurView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        this.createStubController();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BlurView, defStyleAttr, 0);
        int defaultColor = ContextCompat.getColor((Context)this.getContext(), (int)17170445);
        this.overlayColor = a.getColor(R.styleable.BlurView_blurOverlayColor, defaultColor);
        a.recycle();
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        if (!this.blurController.isInternalCanvas(canvas)) {
            this.blurController.drawBlurredContent(canvas);
            this.drawColorOverlay(canvas);
            super.draw(canvas);
        }
    }

    public void stopAutoBlurUpdate() {
        this.blurController.stopAutoBlurUpdate();
    }

    public void updateBlur() {
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.blurController.updateBlurViewSize();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.blurController.onDrawEnd(canvas);
    }

    private void drawColorOverlay(Canvas canvas) {
        canvas.drawColor(this.overlayColor);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.blurController.destroy();
    }

    public void setBlurController(@NonNull BlurController blurController) {
        this.blurController.destroy();
        this.blurController = blurController;
    }

    public void setOverlayColor(@ColorInt int overlayColor) {
        this.overlayColor = overlayColor;
        this.invalidate();
    }

    public ControllerSettings setupWith(View rootView) {
        DefaultBlurController blurController = new DefaultBlurController((View)this, rootView);
        this.setBlurController(blurController);
        return new ControllerSettings(blurController);
    }

    private void createStubController() {
        this.blurController = new BlurController(){

            @Override
            public boolean isInternalCanvas(Canvas canvas) {
                return false;
            }

            @Override
            public void drawBlurredContent(Canvas canvas) {
            }

            @Override
            public void updateBlurViewSize() {
            }

            @Override
            public void onDrawEnd(Canvas canvas) {
            }

            @Override
            public void stopAutoBlurUpdate() {
            }

            @Override
            public void setBlurRadius(float radius) {
            }

            @Override
            public void setBlurAlgorithm(BlurAlgorithm algorithm) {
            }

            @Override
            public void setWindowBackground(@Nullable Drawable windowBackground) {
            }

            @Override
            public void destroy() {
            }
        };
    }

    public static class ControllerSettings {
        BlurController blurController;

        private ControllerSettings(BlurController blurController) {
            this.blurController = blurController;
        }

        public ControllerSettings blurRadius(float radius) {
            this.blurController.setBlurRadius(radius);
            return this;
        }

        public ControllerSettings blurAlgorithm(BlurAlgorithm algorithm) {
            this.blurController.setBlurAlgorithm(algorithm);
            return this;
        }

        public ControllerSettings windowBackground(@Nullable Drawable windowBackground) {
            this.blurController.setWindowBackground(windowBackground);
            return this;
        }
    }
}

