/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker.data;

import android.content.SharedPreferences;
import android.net.Uri;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimateringtonepicker.data.CustomRingtone;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/aprildown/ultimateringtonepicker/data/CustomRingtoneDAO;", "", "prefs", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "addCustomRingtone", "Lxyz/aprildown/ultimateringtonepicker/data/CustomRingtone;", "uri", "Landroid/net/Uri;", "title", "", "getCustomRingtones", "", "getRingtoneIds", "", "removeCustomRingtone", "", "id", "", "Companion", "xyz.aprildown.ultimateringtonepicker.library"})
public final class CustomRingtoneDAO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private static final String RINGTONE_IDS = "music_ids";
    @NotNull
    private static final String NEXT_RINGTONE_ID = "next_music_id";
    @NotNull
    private static final String RINGTONE_URI = "music_uri_";
    @NotNull
    private static final String RINGTONE_TITLE = "music_title_";

    public CustomRingtoneDAO(@NotNull SharedPreferences prefs) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.prefs = prefs;
    }

    @NotNull
    public final CustomRingtone addCustomRingtone(@NotNull Uri uri, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        long id2 = this.prefs.getLong(NEXT_RINGTONE_ID, 0L);
        Set<String> ids = this.getRingtoneIds();
        ids.add(String.valueOf(id2));
        this.prefs.edit().putString(RINGTONE_URI + id2, uri.toString()).putString(RINGTONE_TITLE + id2, title).putLong(NEXT_RINGTONE_ID, id2 + 1L).putStringSet(RINGTONE_IDS, ids).apply();
        return new CustomRingtone(id2, uri, title);
    }

    public final void removeCustomRingtone(long id2) {
        Set<String> ids = this.getRingtoneIds();
        ids.remove(String.valueOf(id2));
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.remove(RINGTONE_URI + id2);
        editor.remove(RINGTONE_TITLE + id2);
        if (ids.isEmpty()) {
            editor.remove(RINGTONE_IDS);
            editor.remove(NEXT_RINGTONE_ID);
        } else {
            editor.putStringSet(RINGTONE_IDS, ids);
        }
        editor.apply();
    }

    @NotNull
    public final List<CustomRingtone> getCustomRingtones() {
        Set set = this.prefs.getStringSet(RINGTONE_IDS, null);
        if (set == null) {
            return new ArrayList();
        }
        Set ids = set;
        ArrayList<CustomRingtone> ringtones = new ArrayList<CustomRingtone>(ids.size());
        for (String id2 : ids) {
            String title;
            Intrinsics.checkNotNull((Object)id2);
            Long l = StringsKt.toLongOrNull((String)id2);
            if (l == null) {
                continue;
            }
            long idLong = l;
            String string2 = this.prefs.getString(RINGTONE_URI + id2, null);
            if (string2 == null) continue;
            Uri uri = Uri.parse((String)string2);
            if (this.prefs.getString(RINGTONE_TITLE + id2, null) == null) continue;
            Intrinsics.checkNotNull((Object)uri);
            ringtones.add(new CustomRingtone(idLong, uri, title));
        }
        return ringtones;
    }

    private final Set<String> getRingtoneIds() {
        Set set = this.prefs.getStringSet(RINGTONE_IDS, null);
        return set == null ? (Set)new LinkedHashSet() : set;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lxyz/aprildown/ultimateringtonepicker/data/CustomRingtoneDAO$Companion;", "", "()V", "NEXT_RINGTONE_ID", "", "RINGTONE_IDS", "RINGTONE_TITLE", "RINGTONE_URI", "xyz.aprildown.ultimateringtonepicker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

