/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker.data;

import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import androidx.collection.ArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimateringtonepicker.R;
import xyz.aprildown.ultimateringtonepicker.UtilsKt;
import xyz.aprildown.ultimateringtonepicker.data.SystemRingtoneModelKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/aprildown/ultimateringtonepicker/data/SystemRingtoneModel;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "ringtoneTitles", "Landroidx/collection/ArrayMap;", "Landroid/net/Uri;", "", "getRingtoneTitle", "uri", "getRingtones", "", "type", "", "preloadRingtoneTitles", "", "types", "library_release"})
public final class SystemRingtoneModel {
    @NotNull
    private final Context context;
    @NotNull
    private final ArrayMap<Uri, String> ringtoneTitles;

    public SystemRingtoneModel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.ringtoneTitles = new ArrayMap(16);
    }

    public final void preloadRingtoneTitles(@NotNull List<Integer> types) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        if (!this.ringtoneTitles.isEmpty()) {
            return;
        }
        Iterator<Integer> iterator = types.iterator();
        while (iterator.hasNext()) {
            int type = ((Number)iterator.next()).intValue();
            if (!SystemRingtoneModelKt.access$isValidRingtoneManagerType(type)) continue;
            RingtoneManager ringtoneManager = new RingtoneManager(this.context);
            ringtoneManager.setType(type);
            try {
                Cursor cursor = ringtoneManager.getCursor();
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String ringtoneTitle = cursor.getString(1);
                    Uri ringtoneUri = ringtoneManager.getRingtoneUri(cursor.getPosition());
                    Map map = (Map)this.ringtoneTitles;
                    boolean bl = false;
                    map.put(ringtoneUri, ringtoneTitle);
                    cursor.moveToNext();
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    @NotNull
    public final String getRingtoneTitle(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)UtilsKt.getRINGTONE_URI_NULL(), (Object)uri)) {
            String string2 = this.context.getString(R.string.urp_silent_ringtone_title);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026rp_silent_ringtone_title)");
            return string2;
        }
        String title = (String)this.ringtoneTitles.get((Object)uri);
        if (title == null) {
            Ringtone ringtone = RingtoneManager.getRingtone((Context)this.context, (Uri)uri);
            Object object = ringtone == null ? null : ringtone.getTitle(this.context);
            title = object == null ? this.context.getString(R.string.urp_unknown_ringtone_title) : object;
            object = (Map)this.ringtoneTitles;
            boolean bl = false;
            object.put(uri, title);
        }
        return title;
    }

    @NotNull
    public final List<Uri> getRingtones(int type) {
        Cursor cursor;
        if (!SystemRingtoneModelKt.access$isValidRingtoneManagerType(type)) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List result = new ArrayList();
        RingtoneManager ringtoneManager = new RingtoneManager(this.context);
        ringtoneManager.setType(type);
        try {
            cursor = ringtoneManager.getCursor();
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"{\n            ringtoneManager.cursor\n        }");
        }
        catch (Exception e) {
            cursor = (Cursor)new MatrixCursor(new String[0]);
        }
        Cursor systemRingtoneCursor = cursor;
        int n = 0;
        int n2 = systemRingtoneCursor.getCount();
        if (n < n2) {
            do {
                int i = n++;
                Uri uri = ringtoneManager.getRingtoneUri(i);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"ringtoneManager.getRingtoneUri(i)");
                result.add(uri);
            } while (n < n2);
        }
        return result;
    }
}

