/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker.data;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimateringtonepicker.UltimateRingtonePicker;
import xyz.aprildown.ultimateringtonepicker.data.Category;
import xyz.aprildown.ultimateringtonepicker.data.DeviceRingtoneModel$WhenMappings;
import xyz.aprildown.ultimateringtonepicker.data.Ringtone;
import xyz.aprildown.ultimateringtonepicker.data.folder.RingtoneFolderRetrieverCompat;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/aprildown/ultimateringtonepicker/data/DeviceRingtoneModel;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getAlbums", "", "Lxyz/aprildown/ultimateringtonepicker/data/Category;", "getAllDeviceRingtones", "Lxyz/aprildown/ultimateringtonepicker/data/Ringtone;", "getArtists", "getCategories", "categoryType", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneCategoryType;", "getFolderRingtones", "folderId", "", "getFolders", "library_release"})
public final class DeviceRingtoneModel {
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Ringtone> getAllDeviceRingtones() {
        boolean bl = false;
        List data = new ArrayList();
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, new String[]{"_id", "title", "artist_id", "album_id"}, "is_podcast == 0 AND\n(\n    is_music != 0 OR\n    is_alarm != 0 OR\n    is_notification != 0 OR\n    is_ringtone != 0\n)", null, "title_key");
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl4 = false;
                it.moveToPosition(-1);
                while (it.moveToNext()) {
                    try {
                        Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)it.getLong(it.getColumnIndexOrThrow("_id")));
                        String title = it.getString(it.getColumnIndexOrThrow("title"));
                        long artistId = it.getLong(it.getColumnIndexOrThrow("artist_id"));
                        long albumId = it.getLong(it.getColumnIndexOrThrow("album_id"));
                        Uri uri2 = uri;
                        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"uri");
                        String string2 = title;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"title");
                        data.add(new Ringtone(uri2, string2, artistId, albumId, false, 16, null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Category> getArtists() {
        boolean bl = false;
        List data = new ArrayList();
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI, new String[]{"_id", "artist", "number_of_tracks"}, null, null, "artist_key");
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl4 = false;
                it.moveToPosition(-1);
                while (it.moveToNext()) {
                    try {
                        long id2 = it.getLong(it.getColumnIndexOrThrow("_id"));
                        String name = it.getString(it.getColumnIndexOrThrow("artist"));
                        int numOfTracks = it.getInt(it.getColumnIndexOrThrow("number_of_tracks"));
                        String string2 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                        data.add(new Category(UltimateRingtonePicker.RingtoneCategoryType.Artist, id2, string2, numOfTracks));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Category> getAlbums() {
        boolean bl = false;
        List data = new ArrayList();
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI, new String[]{"_id", "album", "numsongs"}, null, null, "album_key");
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl4 = false;
                it.moveToPosition(-1);
                while (it.moveToNext()) {
                    try {
                        long id2 = it.getLong(it.getColumnIndexOrThrow("_id"));
                        String name = it.getString(it.getColumnIndexOrThrow("album"));
                        int numOfSongs = it.getInt(it.getColumnIndexOrThrow("numsongs"));
                        String string2 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                        data.add(new Category(UltimateRingtonePicker.RingtoneCategoryType.Album, id2, string2, numOfSongs));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return data;
    }

    private final List<Category> getFolders() {
        return new RingtoneFolderRetrieverCompat(this.context).getRingtoneFolders();
    }

    @NotNull
    public final List<Ringtone> getFolderRingtones(long folderId) {
        return new RingtoneFolderRetrieverCompat(this.context).getRingtonesFromFolder(folderId);
    }

    @NotNull
    public final List<Category> getCategories(@NotNull UltimateRingtonePicker.RingtoneCategoryType categoryType) {
        List<Category> list;
        Intrinsics.checkNotNullParameter((Object)((Object)categoryType), (String)"categoryType");
        switch (DeviceRingtoneModel$WhenMappings.$EnumSwitchMapping$0[categoryType.ordinal()]) {
            case 1: {
                list = this.getArtists();
                break;
            }
            case 2: {
                list = this.getAlbums();
                break;
            }
            case 3: {
                list = this.getFolders();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Wrong category categoryType: " + (Object)((Object)categoryType));
            }
        }
        return list;
    }

    public DeviceRingtoneModel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

